/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.tagmanager.zzad;
import com.google.android.gms.tagmanager.zzan;
import com.google.android.gms.tagmanager.zzas;
import com.google.android.gms.tagmanager.zzaw;
import com.google.android.gms.tagmanager.zzax;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzdc;
import com.google.android.gms.tagmanager.zzdf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class zzcg
implements zzaw {
    private static final String bo = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL,'%s' INTEGER NOT NULL);", "gtm_hits", "hit_id", "hit_time", "hit_url", "hit_first_send_time");
    private final zzb aCP;
    private volatile zzad aCQ;
    private final zzax aCR;
    private final Context mContext;
    private final String aCS;
    private long aCT;
    private zze zzapy;
    private final int aCU;

    zzcg(zzax zzax2, Context context) {
        this(zzax2, context, "gtm_urls.db", 2000);
    }

    zzcg(zzax zzax2, Context context, String string, int n) {
        this.mContext = context.getApplicationContext();
        this.aCS = string;
        this.aCR = zzax2;
        this.zzapy = zzh.zzaxj();
        this.aCP = new zzb(this.mContext, this.aCS);
        this.aCQ = new zzdf(this.mContext, new zza());
        this.aCT = 0L;
        this.aCU = n;
    }

    @Override
    public void zzg(long l, String string) {
        this.zzabp();
        this.zzcfu();
        this.zzh(l, string);
    }

    private void zzcfu() {
        int n = this.zzcfv() - this.aCU + 1;
        if (n > 0) {
            List<String> list = this.zzaaq(n);
            int n2 = list.size();
            zzbo.v(new StringBuilder(51).append("Store full, deleting ").append(n2).append(" hits to make room.").toString());
            this.zzh(list.toArray(new String[0]));
        }
    }

    private void zzh(long l, String string) {
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_time", Long.valueOf(l));
        contentValues.put("hit_url", string);
        contentValues.put("hit_first_send_time", Integer.valueOf(0));
        try {
            sQLiteDatabase.insert("gtm_hits", null, contentValues);
            this.aCR.zzcl(false);
        }
        catch (SQLiteException sQLiteException) {
            zzbo.zzdf("Error storing hit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> zzaaq(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            zzbo.zzdf("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzas> zzaar(int n) {
        ArrayList<zzas> arrayList = new ArrayList<zzas>();
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_time", "hit_first_send_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    zzas zzas2 = new zzas(cursor.getLong(0), cursor.getLong(1), cursor.getLong(2));
                    arrayList.add(zzas2);
                } while (cursor.moveToNext());
            }
        }
        int n2 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((zzas)arrayList.get(n2)).zzpk(cursor.getString(1));
                    } else {
                        zzbo.zzdf(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((zzas)arrayList.get(n2)).zzcfh()));
                    }
                    ++n2;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            String string = String.valueOf(sQLiteException.getMessage());
            zzbo.zzdf(string.length() != 0 ? "Error in peekHits fetching hit url: ".concat(string) : new String("Error in peekHits fetching hit url: "));
            ArrayList<zzas> arrayList2 = new ArrayList<zzas>();
            boolean bl = false;
            for (zzas zzas3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)zzas3.zzcfj())) {
                    if (bl) break;
                    bl = true;
                }
                arrayList2.add(zzas3);
            }
            ArrayList<zzas> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int zzabp() {
        long l = this.zzapy.currentTimeMillis();
        if (l <= this.aCT + 86400000L) {
            return 0;
        }
        this.aCT = l;
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l2 = this.zzapy.currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("gtm_hits", "HIT_TIME < ?", new String[]{Long.toString(l2)});
        this.aCR.zzcl(this.zzcfv() == 0);
        return n;
    }

    void zzh(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("gtm_hits", string, stringArray);
            this.aCR.zzcl(this.zzcfv() == 0);
        }
        catch (SQLiteException sQLiteException) {
            zzbo.zzdf("Error deleting hits");
        }
    }

    private void zzu(long l) {
        this.zzh(new String[]{String.valueOf(l)});
    }

    private void zzi(long l, long l2) {
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_first_send_time", Long.valueOf(l2));
        try {
            sQLiteDatabase.update("gtm_hits", contentValues, "hit_id=?", new String[]{String.valueOf(l)});
        }
        catch (SQLiteException sQLiteException) {
            zzbo.zzdf(new StringBuilder(69).append("Error setting HIT_FIRST_DISPATCH_TIME for hitId: ").append(l).toString());
            this.zzu(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zzcfv() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from gtm_hits", null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zzcfw() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_first_send_time"}, "hit_first_send_time=0", null, null, null, null);
            n = cursor.getCount();
        }
        return n;
    }

    @Override
    public void dispatch() {
        zzbo.v("GTM Dispatch running...");
        if (!this.aCQ.zzcex()) {
            return;
        }
        List<zzas> list = this.zzaar(40);
        if (list.isEmpty()) {
            zzbo.v("...nothing to dispatch");
            this.aCR.zzcl(true);
            return;
        }
        this.aCQ.zzal(list);
        if (this.zzcfw() > 0) {
            zzdc.zzcgs().dispatch();
        }
    }

    private SQLiteDatabase zzpg(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.aCP.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzbo.zzdf(string);
            return null;
        }
        return sQLiteDatabase;
    }

    class zzb
    extends SQLiteOpenHelper {
        private boolean aCW;
        private long aCX;

        zzb(Context context, String string) {
            super(context, string, null, 1);
            this.aCX = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.aCW && this.aCX + 3600000L > zzcg.this.zzapy.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.aCW = true;
            this.aCX = zzcg.this.zzapy.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzcg.this.mContext.getDatabasePath(zzcg.this.aCS).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.aCW = false;
            return sQLiteDatabase;
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza("gtm_hits", sQLiteDatabase)) {
                sQLiteDatabase.execSQL(bo);
            } else {
                this.zzc(sQLiteDatabase);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zzc(SQLiteDatabase sQLiteDatabase) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM gtm_hits WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_time") && hashSet.remove("hit_first_send_time"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzan.zzfa(sQLiteDatabase.getPath());
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }

    class zza
    implements zzdf.zza {
        zza() {
        }

        @Override
        public void zza(zzas zzas2) {
            zzcg.this.zzu(zzas2.zzcfh());
        }

        @Override
        public void zzb(zzas zzas2) {
            zzcg.this.zzu(zzas2.zzcfh());
            long l = zzas2.zzcfh();
            zzbo.v(new StringBuilder(57).append("Permanent failure dispatching hitId: ").append(l).toString());
        }

        @Override
        public void zzc(zzas zzas2) {
            long l = zzas2.zzcfi();
            if (l == 0L) {
                zzcg.this.zzi(zzas2.zzcfh(), zzcg.this.zzapy.currentTimeMillis());
            } else if (l + 14400000L < zzcg.this.zzapy.currentTimeMillis()) {
                zzcg.this.zzu(zzas2.zzcfh());
                long l2 = zzas2.zzcfh();
                zzbo.v(new StringBuilder(47).append("Giving up on failed hitId: ").append(l2).toString());
            }
        }
    }
}

