/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.annotation.TargetApi;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RawRes;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.tagmanager.ContainerHolder;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzcj;
import com.google.android.gms.tagmanager.zzd;
import com.google.android.gms.tagmanager.zzdb;
import com.google.android.gms.tagmanager.zzdc;
import com.google.android.gms.tagmanager.zzo;
import com.google.android.gms.tagmanager.zzp;
import com.google.android.gms.tagmanager.zzt;
import com.google.android.gms.tagmanager.zzx;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TagManager {
    private final zza aEv;
    private final Context mContext;
    private final DataLayer aAP;
    private final zzdb aEw;
    private final ConcurrentMap<String, zzo> aEx;
    private final zzt aDs;
    private static TagManager aEy;

    TagManager(Context context, zza zza2, DataLayer dataLayer, zzdb zzdb2) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.aEw = zzdb2;
        this.aEv = zza2;
        this.aEx = new ConcurrentHashMap<String, zzo>();
        this.aAP = dataLayer;
        this.aAP.zza(new DataLayer.zzb(){

            @Override
            public void zzax(Map<String, Object> map) {
                Object object = map.get("event");
                if (object != null) {
                    TagManager.this.zzpu(object.toString());
                }
            }
        });
        this.aAP.zza(new zzd(this.mContext));
        this.aDs = new zzt();
        this.zzcgy();
        this.zzcgz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static TagManager getInstance(Context context) {
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (aEy == null) {
                if (context == null) {
                    zzbo.e("TagManager.getInstance requires non-null context.");
                    throw new NullPointerException();
                }
                zza zza2 = new zza(){

                    @Override
                    public zzp zza(Context context, TagManager tagManager, Looper looper, String string, int n, zzt zzt2) {
                        return new zzp(context, tagManager, looper, string, n, zzt2);
                    }
                };
                zzx zzx2 = new zzx(context);
                aEy = new TagManager(context, zza2, new DataLayer(zzx2), zzdc.zzcgs());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return aEy;
        }
    }

    public DataLayer getDataLayer() {
        return this.aAP;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String string, @RawRes int n) {
        zzp zzp2 = this.aEv.zza(this.mContext, this, null, string, n, this.aDs);
        zzp2.zzceb();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String string, @RawRes int n, Handler handler) {
        zzp zzp2 = this.aEv.zza(this.mContext, this, handler.getLooper(), string, n, this.aDs);
        zzp2.zzceb();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String string, @RawRes int n) {
        zzp zzp2 = this.aEv.zza(this.mContext, this, null, string, n, this.aDs);
        zzp2.zzcec();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String string, @RawRes int n, Handler handler) {
        zzp zzp2 = this.aEv.zza(this.mContext, this, handler.getLooper(), string, n, this.aDs);
        zzp2.zzcec();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String string, @RawRes int n) {
        zzp zzp2 = this.aEv.zza(this.mContext, this, null, string, n, this.aDs);
        zzp2.zzced();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String string, @RawRes int n, Handler handler) {
        zzp zzp2 = this.aEv.zza(this.mContext, this, handler.getLooper(), string, n, this.aDs);
        zzp2.zzced();
        return zzp2;
    }

    public void dispatch() {
        this.aEw.dispatch();
    }

    public void setVerboseLoggingEnabled(boolean bl) {
        zzbo.setLogLevel(bl ? 2 : 5);
    }

    synchronized boolean zzu(Uri uri) {
        zzcj zzcj2 = zzcj.zzcfy();
        if (zzcj2.zzu(uri)) {
            String string = zzcj2.getContainerId();
            switch (zzcj2.zzcfz()) {
                case aDf: {
                    zzo zzo2 = (zzo)this.aEx.get(string);
                    if (zzo2 == null) break;
                    zzo2.zzoy(null);
                    zzo2.refresh();
                    break;
                }
                case aDg: 
                case aDh: {
                    for (String string2 : this.aEx.keySet()) {
                        zzo zzo3 = (zzo)this.aEx.get(string2);
                        if (string2.equals(string)) {
                            zzo3.zzoy(zzcj2.zzcga());
                            zzo3.refresh();
                            continue;
                        }
                        if (zzo3.zzcdy() == null) continue;
                        zzo3.zzoy(null);
                        zzo3.refresh();
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public int zza(zzo zzo2) {
        this.aEx.put(zzo2.getContainerId(), zzo2);
        return this.aEx.size();
    }

    public boolean zzb(zzo zzo2) {
        return this.aEx.remove(zzo2.getContainerId()) != null;
    }

    private void zzpu(String string) {
        for (zzo zzo2 : this.aEx.values()) {
            zzo2.zzow(string);
        }
    }

    @TargetApi(value=14)
    private void zzcgy() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

                public void onTrimMemory(int n) {
                    if (n == 20) {
                        TagManager.this.dispatch();
                    }
                }

                public void onConfigurationChanged(Configuration configuration) {
                }

                public void onLowMemory() {
                }
            });
        }
    }

    private void zzcgz() {
        com.google.android.gms.tagmanager.zza.zzdz(this.mContext);
    }

    public static interface zza {
        public zzp zza(Context var1, TagManager var2, Looper var3, String var4, int var5, zzt var6);
    }
}

