/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import com.google.android.gms.tagmanager.zzbo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataLayer {
    public static final Object OBJECT_NOT_PRESENT = new Object();
    public static final String EVENT_KEY = "event";
    static final String[] aBv = "gtm.lifetime".toString().split("\\.");
    private static final Pattern aBw = Pattern.compile("(\\d+)\\s*([smhd]?)");
    private final ConcurrentHashMap<zzb, Integer> aBx;
    private final Map<String, Object> aBy;
    private final ReentrantLock aBz;
    private final LinkedList<Map<String, Object>> aBA;
    private final zzc aBB;
    private final CountDownLatch aBC;

    DataLayer() {
        this(new zzc(){

            @Override
            public void zza(List<zza> list, long l) {
            }

            @Override
            public void zza(zzc.zza zza2) {
                zza2.zzai(new ArrayList<zza>());
            }

            @Override
            public void zzpe(String string) {
            }
        });
    }

    DataLayer(zzc zzc2) {
        this.aBB = zzc2;
        this.aBx = new ConcurrentHashMap();
        this.aBy = new HashMap<String, Object>();
        this.aBz = new ReentrantLock();
        this.aBA = new LinkedList();
        this.aBC = new CountDownLatch(1);
        this.zzceo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, Object> map = this.aBy;
        synchronized (map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.aBy.entrySet()) {
                stringBuilder.append(String.format("{\n\tKey: %s\n\tValue: %s\n}\n", entry.getKey(), entry.getValue()));
            }
            return stringBuilder.toString();
        }
    }

    public void pushEvent(String string, Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        hashMap.put(EVENT_KEY, string);
        this.push(hashMap);
    }

    public void push(String string, Object object) {
        Map<String, Object> map = this.zzo(string, object);
        this.push(map);
    }

    public void push(Map<String, Object> map) {
        try {
            this.aBC.await();
        }
        catch (InterruptedException interruptedException) {
            zzbo.zzdf("DataLayer.push: unexpected InterruptedException");
        }
        this.zzaz(map);
    }

    private void zzaz(Map<String, Object> map) {
        this.aBz.lock();
        try {
            this.aBA.offer(map);
            if (this.aBz.getHoldCount() == 1) {
                this.zzcep();
            }
            this.zzba(map);
        }
        finally {
            this.aBz.unlock();
        }
    }

    private void zzceo() {
        this.aBB.zza(new zzc.zza(){

            @Override
            public void zzai(List<zza> list) {
                for (zza zza2 : list) {
                    DataLayer.this.zzaz(DataLayer.this.zzo(zza2.zzbaf, zza2.zzctv));
                }
                DataLayer.this.aBC.countDown();
            }
        });
    }

    private void zzba(Map<String, Object> map) {
        Long l = this.zzbb(map);
        if (l == null) {
            return;
        }
        List<zza> list = this.zzbd(map);
        list.remove("gtm.lifetime");
        this.aBB.zza(list, l);
    }

    private Long zzbb(Map<String, Object> map) {
        Object object = this.zzbc(map);
        if (object == null) {
            return null;
        }
        return DataLayer.zzpd(object.toString());
    }

    private Object zzbc(Map<String, Object> map) {
        Object object = map;
        for (String string : aBv) {
            if (!(object instanceof Map)) {
                return null;
            }
            Map<String, Object> map2 = object;
            object = map2.get(string);
        }
        return object;
    }

    void zzpc(String string) {
        this.push(string, null);
        this.aBB.zzpe(string);
    }

    private List<zza> zzbd(Map<String, Object> map) {
        ArrayList<zza> arrayList = new ArrayList<zza>();
        this.zza(map, "", arrayList);
        return arrayList;
    }

    private void zza(Map<String, Object> map, String string, Collection<zza> collection) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = string.length() == 0 ? "" : ".";
            String string2 = entry.getKey();
            String string3 = new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(object).length() + String.valueOf(string2).length()).append(string).append((String)object).append(string2).toString();
            if (entry.getValue() instanceof Map) {
                object = (Map)entry.getValue();
                this.zza((Map<String, Object>)object, string3, collection);
                continue;
            }
            if (string3.equals("gtm.lifetime")) continue;
            collection.add(new zza(string3, entry.getValue()));
        }
    }

    static Long zzpd(String string) {
        Matcher matcher = aBw.matcher(string);
        if (!matcher.matches()) {
            String string2 = String.valueOf(string);
            zzbo.zzde(string2.length() != 0 ? "unknown _lifetime: ".concat(string2) : new String("unknown _lifetime: "));
            return null;
        }
        long l = 0L;
        try {
            l = Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(string);
            zzbo.zzdf(string3.length() != 0 ? "illegal number in _lifetime value: ".concat(string3) : new String("illegal number in _lifetime value: "));
        }
        if (l <= 0L) {
            String string4 = String.valueOf(string);
            zzbo.zzde(string4.length() != 0 ? "non-positive _lifetime: ".concat(string4) : new String("non-positive _lifetime: "));
            return null;
        }
        String string5 = matcher.group(2);
        if (string5.length() == 0) {
            return l;
        }
        switch (string5.charAt(0)) {
            case 's': {
                return l * 1000L;
            }
            case 'm': {
                return l * 1000L * 60L;
            }
            case 'h': {
                return l * 1000L * 60L * 60L;
            }
            case 'd': {
                return l * 1000L * 60L * 60L * 24L;
            }
        }
        String string6 = String.valueOf(string);
        zzbo.zzdf(string6.length() != 0 ? "unknown units in _lifetime: ".concat(string6) : new String("unknown units in _lifetime: "));
        return null;
    }

    private void zzcep() {
        Map<String, Object> map;
        int n = 0;
        while ((map = this.aBA.poll()) != null) {
            this.zzbe(map);
            if (++n <= 500) continue;
            this.aBA.clear();
            throw new RuntimeException("Seems like an infinite loop of pushing to the data layer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzbe(Map<String, Object> map) {
        Map<String, Object> map2 = this.aBy;
        synchronized (map2) {
            for (String string : map.keySet()) {
                this.zzd(this.zzo(string, map.get(string)), this.aBy);
            }
        }
        this.zzbf(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String string) {
        Map<String, Object> map = this.aBy;
        synchronized (map) {
            String[] stringArray;
            Object object = this.aBy;
            for (String string2 : stringArray = string.split("\\.")) {
                if (!(object instanceof Map)) {
                    return null;
                }
                Object object2 = object;
                Object object3 = object2.get(string2);
                if (object3 == null) {
                    return null;
                }
                object = object3;
            }
            return object;
        }
    }

    public static Map<String, Object> mapOf(Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of key-value pairs");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!(objectArray[i] instanceof String)) {
                String string = String.valueOf(objectArray[i]);
                throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string).length()).append("key is not a string: ").append(string).toString());
            }
            hashMap.put((String)objectArray[i], objectArray[i + 1]);
        }
        return hashMap;
    }

    public static List<Object> listOf(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    void zza(zzb zzb2) {
        this.aBx.put(zzb2, 0);
    }

    private void zzbf(Map<String, Object> map) {
        for (zzb zzb2 : this.aBx.keySet()) {
            zzb2.zzax(map);
        }
    }

    Map<String, Object> zzo(String string, Object object) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap = new HashMap<String, Object>();
        String[] stringArray = string.toString().split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            HashMap hashMap3 = new HashMap();
            hashMap2.put(stringArray[i], hashMap3);
            hashMap2 = hashMap3;
        }
        hashMap2.put(stringArray[stringArray.length - 1], object);
        return hashMap;
    }

    void zzd(Map<String, Object> map, Map<String, Object> map2) {
        for (String string : map.keySet()) {
            Object object;
            Object object2;
            Object object3 = map.get(string);
            if (object3 instanceof List) {
                if (!(map2.get(string) instanceof List)) {
                    map2.put(string, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)map2.get(string);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(map2.get(string) instanceof Map)) {
                    map2.put(string, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)map2.get(string);
                this.zzd((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            map2.put(string, object3);
        }
    }

    void zzb(List<Object> list, List<Object> list2) {
        while (list2.size() < list.size()) {
            list2.add(null);
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3 = list.get(i);
            if (object3 instanceof List) {
                if (!(list2.get(i) instanceof List)) {
                    list2.set(i, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)list2.get(i);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(list2.get(i) instanceof Map)) {
                    list2.set(i, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)list2.get(i);
                this.zzd((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            if (object3 == OBJECT_NOT_PRESENT) continue;
            list2.set(i, object3);
        }
    }

    static interface zzc {
        public void zza(List<com.google.android.gms.tagmanager.DataLayer$zza> var1, long var2);

        public void zza(zza var1);

        public void zzpe(String var1);

        public static interface zza {
            public void zzai(List<com.google.android.gms.tagmanager.DataLayer$zza> var1);
        }
    }

    static final class zza {
        public final String zzbaf;
        public final Object zzctv;

        zza(String string, Object object) {
            this.zzbaf = string;
            this.zzctv = object;
        }

        public String toString() {
            String string = this.zzbaf;
            String string2 = String.valueOf(this.zzctv.toString());
            return new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Key: ").append(string).append(" value: ").append(string2).toString();
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])new Integer[]{this.zzbaf.hashCode(), this.zzctv.hashCode()});
        }

        public boolean equals(Object object) {
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return this.zzbaf.equals(zza2.zzbaf) && this.zzctv.equals(zza2.zzctv);
        }
    }

    static interface zzb {
        public void zzax(Map<String, Object> var1);
    }
}

