/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.zzafg;
import com.google.android.gms.internal.zzah;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzaj;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzbw;
import com.google.android.gms.tagmanager.zzcj;
import com.google.android.gms.tagmanager.zzcx;
import com.google.android.gms.tagmanager.zzdm;
import com.google.android.gms.tagmanager.zzu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String aAO;
    private final DataLayer aAP;
    private zzcx aAQ;
    private Map<String, FunctionCallMacroCallback> aAR = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> aAS = new HashMap<String, FunctionCallTagCallback>();
    private volatile long aAT;
    private volatile String aAU = "";

    Container(Context context, DataLayer dataLayer, String string, long l, zzafg.zzc zzc2) {
        this.mContext = context;
        this.aAP = dataLayer;
        this.aAO = string;
        this.aAT = l;
        this.zza(zzc2);
    }

    Container(Context context, DataLayer dataLayer, String string, long l, zzah.zzj zzj2) {
        this.mContext = context;
        this.aAP = dataLayer;
        this.aAO = string;
        this.aAT = l;
        this.zza(zzj2.zzxr);
        if (zzj2.zzxq != null) {
            this.zza(zzj2.zzxq);
        }
    }

    public String getContainerId() {
        return this.aAO;
    }

    public boolean getBoolean(String string) {
        zzcx zzcx2 = this.zzcdx();
        if (zzcx2 == null) {
            zzbo.e("getBoolean called for closed container.");
            return zzdm.zzchi();
        }
        try {
            return zzdm.zzk(zzcx2.zzps(string).getObject());
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception.getMessage());
            zzbo.e(new StringBuilder(66 + String.valueOf(string2).length()).append("Calling getBoolean() threw an exception: ").append(string2).append(" Returning default value.").toString());
            return zzdm.zzchi();
        }
    }

    public double getDouble(String string) {
        zzcx zzcx2 = this.zzcdx();
        if (zzcx2 == null) {
            zzbo.e("getDouble called for closed container.");
            return zzdm.zzchh();
        }
        try {
            return zzdm.zzj(zzcx2.zzps(string).getObject());
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception.getMessage());
            zzbo.e(new StringBuilder(65 + String.valueOf(string2).length()).append("Calling getDouble() threw an exception: ").append(string2).append(" Returning default value.").toString());
            return zzdm.zzchh();
        }
    }

    public long getLong(String string) {
        zzcx zzcx2 = this.zzcdx();
        if (zzcx2 == null) {
            zzbo.e("getLong called for closed container.");
            return zzdm.zzchg();
        }
        try {
            return zzdm.zzi(zzcx2.zzps(string).getObject());
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception.getMessage());
            zzbo.e(new StringBuilder(63 + String.valueOf(string2).length()).append("Calling getLong() threw an exception: ").append(string2).append(" Returning default value.").toString());
            return zzdm.zzchg();
        }
    }

    public String getString(String string) {
        zzcx zzcx2 = this.zzcdx();
        if (zzcx2 == null) {
            zzbo.e("getString called for closed container.");
            return zzdm.zzchk();
        }
        try {
            return zzdm.zzg(zzcx2.zzps(string).getObject());
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception.getMessage());
            zzbo.e(new StringBuilder(65 + String.valueOf(string2).length()).append("Calling getString() threw an exception: ").append(string2).append(" Returning default value.").toString());
            return zzdm.zzchk();
        }
    }

    public long getLastRefreshTime() {
        return this.aAT;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String string, FunctionCallMacroCallback functionCallMacroCallback) {
        if (functionCallMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.aAR;
        synchronized (map) {
            this.aAR.put(string, functionCallMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String string) {
        Map<String, FunctionCallMacroCallback> map = this.aAR;
        synchronized (map) {
            this.aAR.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback zzou(String string) {
        Map<String, FunctionCallMacroCallback> map = this.aAR;
        synchronized (map) {
            return this.aAR.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String string, FunctionCallTagCallback functionCallTagCallback) {
        if (functionCallTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.aAS;
        synchronized (map) {
            this.aAS.put(string, functionCallTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String string) {
        Map<String, FunctionCallTagCallback> map = this.aAS;
        synchronized (map) {
            this.aAS.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionCallTagCallback zzov(String string) {
        Map<String, FunctionCallTagCallback> map = this.aAS;
        synchronized (map) {
            return this.aAS.get(string);
        }
    }

    public void zzow(String string) {
        this.zzcdx().zzow(string);
    }

    public String zzcdw() {
        return this.aAU;
    }

    private void zza(zzah.zzf zzf2) {
        if (zzf2 == null) {
            throw new NullPointerException();
        }
        zzafg.zzc zzc2 = null;
        try {
            zzc2 = zzafg.zzb(zzf2);
        }
        catch (zzafg.zzg zzg2) {
            String string = String.valueOf((Object)zzf2);
            String string2 = String.valueOf(zzg2.toString());
            zzbo.e(new StringBuilder(46 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Not loading resource: ").append(string).append(" because it is invalid: ").append(string2).toString());
            return;
        }
        this.zza(zzc2);
    }

    private void zza(zzah.zzi[] zziArray) {
        ArrayList<zzah.zzi> arrayList = new ArrayList<zzah.zzi>();
        for (zzah.zzi zzi2 : zziArray) {
            arrayList.add(zzi2);
        }
        this.zzcdx().zzam(arrayList);
    }

    private void zza(zzafg.zzc zzc2) {
        this.aAU = zzc2.getVersion();
        zzaj zzaj2 = this.zzox(this.aAU);
        zzcx zzcx2 = new zzcx(this.mContext, zzc2, this.aAP, new zza(), new zzb(), zzaj2);
        this.zza(zzcx2);
        if (this.getBoolean("_gtm.loadEventEnabled")) {
            this.aAP.pushEvent("gtm.load", DataLayer.mapOf("gtm.id", this.aAO));
        }
    }

    zzaj zzox(String string) {
        if (zzcj.zzcfy().zzcfz().equals((Object)zzcj.zza.aDh)) {
            // empty if block
        }
        return new zzbw();
    }

    private synchronized void zza(zzcx zzcx2) {
        this.aAQ = zzcx2;
    }

    private synchronized zzcx zzcdx() {
        return this.aAQ;
    }

    void release() {
        this.aAQ = null;
    }

    private class zzb
    implements zzu.zza {
        private zzb() {
        }

        @Override
        public Object zzf(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.zzov(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return zzdm.zzchk();
        }
    }

    private class zza
    implements zzu.zza {
        private zza() {
        }

        @Override
        public Object zzf(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.zzou(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

