/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzh;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzmi;
import com.google.android.gms.internal.zzmn;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzi {
    private static volatile zzi zzczz;
    private final Context mContext;
    private final List<zzj> a;
    private final zzd b;
    private final zza c;
    private volatile zzmi d;
    private Thread.UncaughtExceptionHandler e;

    zzi(Context context) {
        Context context2 = context.getApplicationContext();
        zzac.zzy((Object)context2);
        this.mContext = context2;
        this.c = new zza();
        this.a = new CopyOnWriteArrayList<zzj>();
        this.b = new zzd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzi zzay(Context context) {
        zzac.zzy((Object)context);
        if (zzczz != null) return zzczz;
        Class<zzi> clazz = zzi.class;
        synchronized (zzi.class) {
            if (zzczz != null) return zzczz;
            zzczz = new zzi(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzczz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzmi zzyj() {
        if (this.d == null) {
            zzi zzi2 = this;
            synchronized (zzi2) {
                if (this.d == null) {
                    zzmi zzmi2 = new zzmi();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzmi2.setAppId(string);
                    zzmi2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzmi2.setAppName(string2);
                    zzmi2.setAppVersion(string3);
                    this.d = zzmi2;
                }
            }
        }
        return this.d;
    }

    public zzmn zzyk() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzmn zzmn2 = new zzmn();
        zzmn2.setLanguage(zzao.zza(Locale.getDefault()));
        zzmn2.zzbw(displayMetrics.widthPixels);
        zzmn2.zzbx(displayMetrics.heightPixels);
        return zzmn2;
    }

    void zze(zze zze2) {
        if (zze2.zzyf()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zze2.zzyb()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        final zze zze3 = zze2.zzxw();
        zze3.zzyc();
        this.c.execute(new Runnable(){

            @Override
            public void run() {
                zzh zzh2 = zze3.zzyd();
                zzh2.zza(zze3);
                for (zzj zzj2 : zzi.this.a) {
                    zzj2.zza(zze3);
                }
                zzi.this.zzb(zze3);
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public static void zzyl() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.e = uncaughtExceptionHandler;
    }

    public <V> Future<V> zzc(Callable<V> callable) {
        zzac.zzy(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.c.submit(callable);
    }

    public void zzg(Runnable runnable) {
        zzac.zzy((Object)runnable);
        this.c.submit(runnable);
    }

    private void zzb(zze zze2) {
        zzac.zzhr((String)"deliver should be called from worker thread");
        zzac.zzb((boolean)zze2.zzyb(), (Object)"Measurement must be submitted");
        List<zzk> list = zze2.zzxy();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzk zzk2 : list) {
            Uri uri = zzk2.zzxl();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzk2.zzb(zze2);
        }
    }

    private static class zzb
    implements ThreadFactory {
        private static final AtomicInteger i = new AtomicInteger();

        private zzb() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            int n = i.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }
    }

    private static class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb());
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new FutureTask<T>(runnable, t){

                @Override
                protected void setException(Throwable throwable) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = zzi.this.e;
                    if (uncaughtExceptionHandler != null) {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                    } else if (Log.isLoggable((String)"GAv4", (int)6)) {
                        String string = String.valueOf(throwable);
                        Log.e((String)"GAv4", (String)new StringBuilder(37 + String.valueOf(string).length()).append("MeasurementExecutor: job failed with ").append(string).toString());
                    }
                    super.setException(throwable);
                }
            };
        }
    }
}

