/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzac;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzn
extends zzd {
    private volatile String ab;
    private Future<String> bN;

    protected zzn(zzf zzf2) {
        super(zzf2);
    }

    @Override
    protected void zzym() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzacm() {
        this.zzaax();
        zzn zzn2 = this;
        synchronized (zzn2) {
            if (this.ab == null) {
                this.bN = this.zzaaq().zzc(new Callable<String>(){

                    public String zzacr() throws Exception {
                        return zzn.this.zzaco();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.zzacr();
                    }
                });
            }
            if (this.bN != null) {
                try {
                    this.ab = this.bN.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.ab = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.ab = "0";
                }
                if (this.ab == null) {
                    this.ab = "0";
                }
                this.zza("Loaded clientId", this.ab);
                this.bN = null;
            }
            return this.ab;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzacn() {
        zzn zzn2 = this;
        synchronized (zzn2) {
            this.ab = null;
            this.bN = this.zzaaq().zzc(new Callable<String>(){

                public String zzacr() throws Exception {
                    return zzn.this.zzacp();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzacr();
                }
            });
        }
        return this.zzacm();
    }

    String zzaco() {
        String string = this.zzbb(this.zzaaq().getContext());
        if (string == null) {
            string = this.zzacp();
        }
        return string;
    }

    private String zzacp() {
        String string = this.zzacq();
        try {
            if (!this.zzp(this.zzaaq().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    protected String zzacq() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String zzbb(Context context) {
        zzac.zzhr((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzes("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                Object var5_9 = null;
                return null;
            }
            if (n < 14) {
                this.zzes("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                Object var5_10 = null;
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object var4_7 = null;
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            Object var4_8 = null;
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzp(Context context, String string) {
        zzac.zzhz((String)string);
        zzac.zzhr((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            boolean bl = true;
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            boolean bl = false;
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            boolean bl = false;
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }
}

