/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzag;
import com.google.android.gms.analytics.internal.zzah;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzak;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzi;
import com.google.android.gms.analytics.internal.zzj;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.analytics.internal.zzv;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzmi;
import com.google.android.gms.internal.zzmj;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzl
extends zzd {
    private boolean mStarted;
    private final zzj bu;
    private final zzah bv;
    private final zzag bw;
    private final zzi bx;
    private long by;
    private final zzt bz;
    private final zzt bA;
    private final zzal bB;
    private long bC;
    private boolean bD;

    protected zzl(zzf zzf2, zzg zzg2) {
        super(zzf2);
        zzac.zzy((Object)zzg2);
        this.by = Long.MIN_VALUE;
        this.bw = zzg2.zzk(zzf2);
        this.bu = zzg2.zzm(zzf2);
        this.bv = zzg2.zzn(zzf2);
        this.bx = zzg2.zzo(zzf2);
        this.bB = new zzal(this.zzaan());
        this.bz = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzabx();
            }
        };
        this.bA = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzaby();
            }
        };
    }

    @Override
    protected void zzym() {
        this.bu.initialize();
        this.bv.initialize();
        this.bx.initialize();
    }

    void start() {
        this.zzaax();
        zzac.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzaaq().zzg(new Runnable(){

            @Override
            public void run() {
                zzl.this.zzabw();
            }
        });
    }

    private void zzabv() {
        boolean bl;
        this.zzyl();
        zzf zzf2 = this.zzaal();
        Context context = zzf2.getContext();
        boolean bl2 = zzaj.zzaw(context);
        if (!bl2) {
            this.zzes("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = zzak.zzax(context);
            if (!bl) {
                this.zzet("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzaw(context);
        if (!bl) {
            this.zzes("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzax(context);
            if (!bl3) {
                this.zzes("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzew(String string) {
        int n = this.getContext().checkCallingOrSelfPermission(string);
        return n == 0;
    }

    protected void zzabw() {
        this.zzaax();
        if (!this.zzaap().zzact()) {
            this.zzabv();
        }
        this.zzaas().zzafe();
        if (!this.zzew("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzet("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzacl();
        }
        if (!this.zzew("android.permission.INTERNET")) {
            this.zzet("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzacl();
        }
        if (zzak.zzax(this.getContext())) {
            this.zzep("AnalyticsService registered in the app manifest and enabled");
        } else if (this.zzaap().zzact()) {
            this.zzet("Device AnalyticsService not registered! Hits will not be delivered reliably.");
        } else {
            this.zzes("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!(this.bD || this.zzaap().zzact() || this.bu.isEmpty())) {
            this.zzabz();
        }
        this.zzacd();
    }

    private void zzabx() {
        this.zzb(new zzw(){

            @Override
            public void zzf(Throwable throwable) {
                zzl.this.zzacd();
            }
        });
    }

    void zzaak() {
        this.zzyl();
        this.bC = this.zzaan().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zzyl();
        if (!this.zzaap().zzact()) {
            this.zzaca();
        }
    }

    public void zzaai() {
        com.google.android.gms.analytics.zzi.zzyl();
        this.zzaax();
        this.zzep("Service disconnected");
    }

    public void zzav(boolean bl) {
        this.zzacd();
    }

    private void zzaby() {
        try {
            this.bu.zzabp();
            this.zzacd();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.bA.zzx(this.zzaap().zzadv());
    }

    protected void zzc(zzh zzh2) {
        this.zzyl();
        this.zzb("Sending first hit to property", zzh2.zzabg());
        if (this.zzaas().zzaff().zzz(this.zzaap().zzady())) {
            return;
        }
        String string = this.zzaas().zzafi();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzmj zzmj2 = zzao.zza(this.zzaao(), string);
        this.zzb("Found relevant installation campaign", zzmj2);
        this.zza(zzh2, zzmj2);
    }

    public void zzw(long l) {
        com.google.android.gms.analytics.zzi.zzyl();
        this.zzaax();
        if (l < 0L) {
            l = 0L;
        }
        this.by = l;
        this.zzacd();
    }

    protected void zzabz() {
        if (this.bD) {
            return;
        }
        if (!this.zzaap().zzacv()) {
            return;
        }
        if (this.bx.isConnected()) {
            return;
        }
        long l = this.zzaap().zzadq();
        if (this.bB.zzz(l)) {
            this.bB.start();
            this.zzep("Connecting to service");
            if (this.bx.connect()) {
                this.zzep("Connected to service");
                this.bB.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzh zzh2, boolean bl) {
        zzac.zzy((Object)zzh2);
        this.zzaax();
        this.zzyl();
        long l = -1L;
        try {
            this.bu.beginTransaction();
            this.bu.zza(zzh2.zzabf(), zzh2.zzxs());
            l = this.bu.zza(zzh2.zzabf(), zzh2.zzxs(), zzh2.zzabg());
            if (!bl) {
                zzh2.zzr(l);
            } else {
                zzh2.zzr(l + 1L);
            }
            this.bu.zzb(zzh2);
            this.bu.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            long l2 = -1L;
            return -1L;
        }
        finally {
            try {
                this.bu.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public void zza(zzab zzab2) {
        zzac.zzy((Object)zzab2);
        com.google.android.gms.analytics.zzi.zzyl();
        this.zzaax();
        if (this.bD) {
            this.zzeq("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzab2);
        }
        zzab2 = this.zzf(zzab2);
        this.zzabz();
        if (this.bx.zzb(zzab2)) {
            this.zzeq("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        if (this.zzaap().zzact()) {
            this.zzaao().zza(zzab2, "Service unavailable on package side");
            return;
        }
        try {
            this.bu.zzc(zzab2);
            this.zzacd();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzaao().zza(zzab2, "deliver: failed to insert hit to database");
        }
    }

    public void zzaaf() {
        com.google.android.gms.analytics.zzi.zzyl();
        this.zzaax();
        if (!this.zzaap().zzact()) {
            this.zzep("Delete all hits from local store");
            try {
                this.bu.zzabn();
                this.bu.zzabo();
                this.zzacd();
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Failed to delete hits from store", (Object)sQLiteException);
            }
        }
        this.zzabz();
        if (this.bx.zzabj()) {
            this.zzep("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzab zzf(zzab zzab2) {
        if (!TextUtils.isEmpty((CharSequence)zzab2.zzaeu())) {
            return zzab2;
        }
        zzai.zza zza2 = this.zzaas().zzafj();
        Pair<String, Long> pair = zza2.zzafm();
        if (pair == null) {
            return zzab2;
        }
        Long l = (Long)pair.second;
        String string = (String)pair.first;
        Object object = String.valueOf(l);
        String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
        object = new HashMap<String, String>(zzab2.zzm());
        object.put("_m", string2);
        return zzab.zza(this, zzab2, (Map<String, String>)object);
    }

    public void zzaca() {
        com.google.android.gms.analytics.zzi.zzyl();
        this.zzaax();
        this.zzaam();
        if (!this.zzaap().zzacv()) {
            this.zzes("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.bx.isConnected()) {
            this.zzep("Service not connected");
            return;
        }
        if (this.bu.isEmpty()) {
            return;
        }
        this.zzep("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzab> list;
            try {
                list = this.bu.zzt(this.zzaap().zzade());
                if (list.isEmpty()) {
                    this.zzacd();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zzach();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzab zzab2 = list.get(0);
                if (!this.bx.zzb(zzab2)) {
                    this.zzacd();
                    return;
                }
                list.remove(zzab2);
                try {
                    this.bu.zzu(zzab2.zzaep());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zzach();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zzacb() {
        boolean bl;
        com.google.android.gms.analytics.zzi.zzyl();
        this.zzaax();
        this.zzep("Dispatching a batch of local hits");
        boolean bl2 = !this.bx.isConnected() && !this.zzaap().zzact();
        boolean bl3 = bl = !this.bv.zzafa();
        if (bl2 && bl) {
            this.zzep("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(this.zzaap().zzade(), this.zzaap().zzadf());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                Object object;
                List<zzab> list;
                block38: {
                    this.bu.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.bu.zzt(l);
                        if (!list.isEmpty()) break block38;
                        this.zzep("Store is empty, nothing to dispatch");
                        this.zzach();
                        boolean bl4 = false;
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzach();
                        boolean bl5 = false;
                        try {
                            this.bu.setTransactionSuccessful();
                            this.bu.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzach();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzab)object).zzaep() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzach();
                    boolean bl6 = false;
                    return false;
                }
                if (this.bx.isConnected() && !this.zzaap().zzact()) {
                    this.zzep("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.bx.zzb((zzab)(object2 = list.get(0)))) {
                        l2 = Math.max(l2, ((zzab)object2).zzaep());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.bu.zzu(((zzab)object2).zzaep());
                            arrayList.add(((zzab)object2).zzaep());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzach();
                            boolean bl7 = false;
                            try {
                                this.bu.setTransactionSuccessful();
                                this.bu.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzach();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.bv.zzafa()) {
                    object2 = this.bv.zzt(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l3 = (Long)object.next();
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.bu.zzr((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzach();
                        boolean bl8 = false;
                        try {
                            this.bu.setTransactionSuccessful();
                            this.bu.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzach();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                boolean bl9 = false;
                return false;
            }
            finally {
                try {
                    this.bu.setTransactionSuccessful();
                    this.bu.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzach();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzw zzw2) {
        this.zza(zzw2, this.bC);
    }

    public void zza(final zzw zzw2, final long l) {
        block8: {
            com.google.android.gms.analytics.zzi.zzyl();
            this.zzaax();
            long l2 = -1L;
            long l3 = this.zzaas().zzafg();
            if (l3 != 0L) {
                l2 = Math.abs(this.zzaan().currentTimeMillis() - l3);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
            if (!this.zzaap().zzact()) {
                this.zzabz();
            }
            try {
                boolean bl = this.zzacb();
                if (bl) {
                    this.zzaaq().zzg(new Runnable(){

                        @Override
                        public void run() {
                            zzl.this.zza(zzw2, l);
                        }
                    });
                } else {
                    this.zzaas().zzafh();
                    this.zzacd();
                    if (zzw2 != null) {
                        zzw2.zzf(null);
                    }
                    if (this.bC != l) {
                        this.bw.zzaez();
                    }
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zzaas().zzafh();
                this.zzacd();
                if (zzw2 == null) break block8;
                zzw2.zzf(throwable);
            }
        }
    }

    public void zzacc() {
        com.google.android.gms.analytics.zzi.zzyl();
        this.zzaax();
        this.zzeq("Sync dispatching local hits");
        long l = this.bC;
        if (!this.zzaap().zzact()) {
            this.zzabz();
        }
        try {
            while (this.zzacb()) {
            }
            this.zzaas().zzafh();
            this.zzacd();
            if (this.bC != l) {
                this.bw.zzaez();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzacd();
        }
    }

    public long zzabq() {
        com.google.android.gms.analytics.zzi.zzyl();
        this.zzaax();
        try {
            return this.bu.zzabq();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zzacd() {
        boolean bl;
        this.zzaal().zzyl();
        this.zzaax();
        if (!this.zzace()) {
            this.bw.unregister();
            this.zzach();
            return;
        }
        if (this.bu.isEmpty()) {
            this.bw.unregister();
            this.zzach();
            return;
        }
        if (!zzy.cN.get().booleanValue()) {
            this.bw.zzaex();
            bl = this.bw.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zzacg();
        } else {
            this.zzach();
            this.zzacf();
        }
    }

    private boolean zzace() {
        if (this.bD) {
            return false;
        }
        if (this.zzaap().zzact() && !this.zzaap().zzacu()) {
            return false;
        }
        return this.zzack() > 0L;
    }

    private void zzacf() {
        long l;
        long l2;
        long l3;
        zzv zzv2 = this.zzaar();
        if (!zzv2.zzaed()) {
            return;
        }
        if (!zzv2.zzfl() && (l3 = this.zzabq()) != 0L && (l2 = Math.abs((l = this.zzaan().currentTimeMillis()) - l3)) <= this.zzaap().zzadd()) {
            long l4 = this.zzaap().zzadc();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l4);
            zzv2.schedule();
        }
    }

    private void zzacg() {
        long l;
        long l2;
        this.zzacf();
        long l3 = this.zzack();
        long l4 = this.zzaas().zzafg();
        long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(this.zzaan().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(this.zzaap().zzada(), l3)) : Math.min(this.zzaap().zzada(), l3);
        this.zza("Dispatch scheduled (ms)", (Object)l5);
        if (this.bz.zzfl()) {
            l = Math.max(1L, l5 + this.bz.zzaea());
            this.bz.zzy(l);
        } else {
            this.bz.zzx(l5);
        }
    }

    private void zzach() {
        this.zzaci();
        this.zzacj();
    }

    private void zzaci() {
        if (this.bz.zzfl()) {
            this.zzep("All hits dispatched or no network/service. Going to power save mode");
        }
        this.bz.cancel();
    }

    private void zzacj() {
        zzv zzv2 = this.zzaar();
        if (zzv2.zzfl()) {
            zzv2.cancel();
        }
    }

    public long zzack() {
        if (this.by != Long.MIN_VALUE) {
            return this.by;
        }
        long l = this.zzaap().zzadb();
        if (this.zzxv().zzaek()) {
            l = (long)this.zzxv().zzagb() * 1000L;
        }
        return l;
    }

    public void zzex(String string) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaam();
        zzmj zzmj2 = zzao.zza(this.zzaao(), string);
        if (zzmj2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzaas().zzafi();
        if (string.equals(string2)) {
            this.zzes("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzaas().zzfc(string);
        if (this.zzaas().zzaff().zzz(this.zzaap().zzady())) {
            this.zzd("Campaign received too late, ignoring", zzmj2);
            return;
        }
        this.zzb("Received installation campaign", zzmj2);
        List<zzh> list = this.bu.zzv(0L);
        for (zzh zzh2 : list) {
            this.zza(zzh2, zzmj2);
        }
    }

    private void zza(zzh zzh2, zzmj zzmj2) {
        zzac.zzy((Object)zzh2);
        zzac.zzy((Object)zzmj2);
        zza zza2 = new zza(this.zzaal());
        zza2.zzdo(zzh2.zzabg());
        zza2.enableAdvertisingIdCollection(zzh2.zzabh());
        zze zze2 = zza2.zzxi();
        zzmr zzmr2 = zze2.zzb(zzmr.class);
        zzmr2.zzee("data");
        zzmr2.zzas(true);
        zze2.zza(zzmj2);
        zzmm zzmm2 = zze2.zzb(zzmm.class);
        zzmi zzmi2 = zze2.zzb(zzmi.class);
        for (Map.Entry<String, String> entry : zzh2.zzm().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzmi2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzmi2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzmi2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzmi2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzmr2.setUserId(string2);
                continue;
            }
            zzmm2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzh2.zzabg(), zzmj2);
        zze2.zzp(this.zzaas().zzafe());
        zze2.zzya();
    }

    public void zzacl() {
        this.zzaax();
        this.zzyl();
        this.bD = true;
        this.bx.disconnect();
        this.zzacd();
    }
}

