/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzx;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzn;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zzj
extends zzd
implements Closeable {
    private static final String bo = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String bp = String.format("SELECT MAX(%s) FROM %s WHERE 1;", "hit_time", "hits2");
    private final zza bq;
    private final zzal br = new zzal(this.zzaan());
    private final zzal bs = new zzal(this.zzaan());

    zzj(zzf zzf2) {
        super(zzf2);
        String string = this.zzabs();
        this.bq = new zza(zzf2.getContext(), string);
    }

    @Override
    protected void zzym() {
    }

    public void beginTransaction() {
        this.zzaax();
        this.getWritableDatabase().beginTransaction();
    }

    public void setTransactionSuccessful() {
        this.zzaax();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public void endTransaction() {
        this.zzaax();
        this.getWritableDatabase().endTransaction();
    }

    public void zzabn() {
        this.zzyl();
        this.zzaax();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("hits2", null, null);
    }

    public void zzabo() {
        this.zzyl();
        this.zzaax();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("properties", null, null);
    }

    public void zzc(zzab zzab2) {
        zzac.zzy((Object)zzab2);
        this.zzyl();
        this.zzaax();
        String string = zzj.zze(zzab2);
        if (string.length() > 8192) {
            this.zzaao().zza(zzab2, "Hit length exceeds the maximum allowed size");
            return;
        }
        this.zzabr();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", string);
        contentValues.put("hit_time", Long.valueOf(zzab2.zzaeq()));
        contentValues.put("hit_app_id", Integer.valueOf(zzab2.zzaeo()));
        contentValues.put("hit_url", this.zzd(zzab2));
        try {
            long l = sQLiteDatabase.insert("hits2", null, contentValues);
            if (l == -1L) {
                this.zzet("Failed to insert a hit (got -1)");
            } else {
                this.zzb("Hit saved to database. db-id, hit", l, zzab2);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a hit", (Object)sQLiteException);
        }
    }

    public long zzabi() {
        this.zzyl();
        this.zzaax();
        long l = this.zzb("SELECT COUNT(*) FROM hits2", null);
        return l;
    }

    boolean isEmpty() {
        return this.zzabi() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> zzs(long l) {
        this.zzyl();
        this.zzaax();
        if (l <= 0L) {
            return Collections.emptyList();
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(cursor.getLong(0));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public List<zzab> zzt(long l) {
        zzac.zzbs((l >= 0L ? 1 : 0) != 0);
        this.zzyl();
        this.zzaax();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time", "hit_string", "hit_url", "hit_app_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            ArrayList<zzab> arrayList = new ArrayList<zzab>();
            if (cursor.moveToFirst()) {
                do {
                    long l2 = cursor.getLong(0);
                    long l3 = cursor.getLong(1);
                    String string = cursor.getString(2);
                    String string2 = cursor.getString(3);
                    int n = cursor.getInt(4);
                    Map<String, String> map = this.zzeu(string);
                    boolean bl = zzao.zzfk(string2);
                    arrayList.add(new zzab(this, map, l3, bl, l2, n));
                } while (cursor.moveToNext());
            }
            ArrayList<zzab> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public void zzr(List<Long> list) {
        Long l;
        zzac.zzy(list);
        this.zzyl();
        this.zzaax();
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("hit_id");
        stringBuilder.append(" in (");
        for (int i = 0; i < list.size(); ++i) {
            l = list.get(i);
            if (l == null || l == 0L) {
                throw new SQLiteException("Invalid hit id");
            }
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(l);
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            l = this.getWritableDatabase();
            this.zza("Deleting dispatched hits. count", list.size());
            int n = l.delete("hits2", string, null);
            if (n != list.size()) {
                this.zzb("Deleted fewer hits then expected", list.size(), n, string);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error deleting hits", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public void zzu(long l) {
        this.zzyl();
        this.zzaax();
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        arrayList.add(l);
        this.zza("Deleting hit, id", l);
        this.zzr(arrayList);
    }

    public int zzabp() {
        this.zzyl();
        this.zzaax();
        if (!this.br.zzz(86400000L)) {
            return 0;
        }
        this.br.start();
        this.zzep("Deleting stale hits (if any)");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        long l = this.zzaan().currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "hit_time < ?", new String[]{Long.toString(l)});
        this.zza("Deleted stale hits, count", n);
        return n;
    }

    public long zzabq() {
        this.zzyl();
        this.zzaax();
        return this.zza(bp, null, 0L);
    }

    public void zza(long l, String string) {
        zzac.zzhz((String)string);
        this.zzaax();
        this.zzyl();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l), string});
        if (n > 0) {
            this.zza("Deleted property records", n);
        }
    }

    public void zzb(zzh zzh2) {
        zzac.zzy((Object)zzh2);
        this.zzaax();
        this.zzyl();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String string = zzj.zzaq(zzh2.zzm());
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_uid", Long.valueOf(zzh2.zzabf()));
        contentValues.put("cid", zzh2.zzxs());
        contentValues.put("tid", zzh2.zzabg());
        contentValues.put("adid", Integer.valueOf(zzh2.zzabh() ? 1 : 0));
        contentValues.put("hits_count", Long.valueOf(zzh2.zzabi()));
        contentValues.put("params", string);
        try {
            long l = sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5);
            if (l == -1L) {
                this.zzet("Failed to insert/update a property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a property", (Object)sQLiteException);
        }
    }

    public long zza(long l, String string, String string2) {
        zzac.zzhz((String)string);
        zzac.zzhz((String)string2);
        this.zzaax();
        this.zzyl();
        long l2 = this.zza("SELECT hits_count FROM properties WHERE app_uid=? AND cid=? AND tid=?", new String[]{String.valueOf(l), string, string2}, 0L);
        return l2;
    }

    public List<zzh> zzv(long l) {
        this.zzaax();
        this.zzyl();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            Object object;
            String[] stringArray = new String[]{"cid", "tid", "adid", "hits_count", "params"};
            int n = this.zzaap().zzads();
            String string = String.valueOf(n);
            String string2 = "app_uid=?";
            String[] stringArray2 = new String[]{String.valueOf(l)};
            cursor = sQLiteDatabase.query("properties", stringArray, string2, stringArray2, null, null, null, string);
            ArrayList<zzh> arrayList = new ArrayList<zzh>();
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(0);
                    String string3 = cursor.getString(1);
                    boolean bl = cursor.getInt(2) != 0;
                    long l2 = cursor.getInt(3);
                    String string4 = cursor.getString(4);
                    Map<String, String> map = this.zzev(string4);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string3)) {
                        this.zzc("Read property with empty client id or tracker id", object, string3);
                        continue;
                    }
                    zzh zzh2 = new zzh(l, (String)object, string3, bl, l2, map);
                    arrayList.add(zzh2);
                } while (cursor.moveToNext());
            }
            if (arrayList.size() >= n) {
                this.zzes("Sending hits to too many properties. Campaign report might be incorrect");
            }
            object = arrayList;
            return object;
        }
    }

    @Override
    public void close() {
        try {
            this.bq.close();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Sql error closing database", (Object)sQLiteException);
        }
        catch (IllegalStateException illegalStateException) {
            this.zze("Error closing database", illegalStateException);
        }
    }

    private String zzd(zzab zzab2) {
        if (zzab2.zzaes()) {
            return this.zzaap().zzadh();
        }
        return this.zzaap().zzadi();
    }

    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l;
        }
    }

    private void zzabr() {
        int n = this.zzaap().zzadr();
        long l = this.zzabi();
        if (l > (long)(n - 1)) {
            long l2 = l - (long)n + 1L;
            List<Long> list = this.zzs(l2);
            this.zzd("Store full, deleting hits to make room, count", list.size());
            this.zzr(list);
        }
    }

    private static String zze(zzab zzab2) {
        zzac.zzy((Object)zzab2);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : zzab2.zzm().entrySet()) {
            String string = object2.getKey();
            if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string)) continue;
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String zzaq(Map<String, String> map) {
        zzac.zzy(map);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            String string = object2.getKey();
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    Map<String, String> zzeu(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2;
            if (string.startsWith("?")) {
                string2 = string;
            } else {
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            String string4 = string2;
            return zzn.zza((URI)new URI(string4), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing hit parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    Map<String, String> zzev(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = String.valueOf(string);
            String string3 = string2.length() != 0 ? "?".concat(string2) : new String("?");
            return zzn.zza((URI)new URI(string3), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing property parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    SQLiteDatabase getWritableDatabase() {
        try {
            return this.bq.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private String zzabs() {
        if (!this.zzaap().zzact()) {
            return this.zzaap().zzadt();
        }
        if (this.zzaap().zzacu()) {
            return this.zzaap().zzadt();
        }
        return this.zzaap().zzadu();
    }

    class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        public SQLiteDatabase getWritableDatabase() {
            if (!zzj.this.bs.zzz(3600000L)) {
                throw new SQLiteException("Database open failed");
            }
            try {
                SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                return sQLiteDatabase;
            }
            catch (SQLiteException sQLiteException) {
                zzj.this.bs.start();
                zzj.this.zzet("Opening the database failed, dropping the table and recreating it");
                String string = zzj.this.zzabs();
                zzj.this.getContext().getDatabasePath(string).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzj.this.bs.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzj.this.zze("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
            try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            return hashSet;
        }

        private void zza(SQLiteDatabase sQLiteDatabase) {
            boolean bl;
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "hits2");
            String[] stringArray2 = stringArray = new String[]{"hit_id", "hit_string", "hit_time", "hit_url"};
            int n = 4;
            for (int i = 0; i < 4; ++i) {
                String string = stringArray2[i];
                if (set.remove(string)) continue;
                String string2 = String.valueOf(string);
                throw new SQLiteException(string2.length() != 0 ? "Database hits2 is missing required column: ".concat(string2) : new String("Database hits2 is missing required column: "));
            }
            boolean bl2 = bl = !set.remove("hit_app_id");
            if (!set.isEmpty()) {
                throw new SQLiteException("Database hits2 has extra columns");
            }
            if (bl) {
                String string = "ALTER TABLE hits2 ADD COLUMN hit_app_id INTEGER";
                sQLiteDatabase.execSQL(string);
            }
        }

        private void zzb(SQLiteDatabase sQLiteDatabase) {
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "properties");
            String[] stringArray2 = stringArray = new String[]{"app_uid", "cid", "tid", "params", "adid", "hits_count"};
            int n = 6;
            for (int i = 0; i < 6; ++i) {
                String string = stringArray2[i];
                if (set.remove(string)) continue;
                String string2 = String.valueOf(string);
                throw new SQLiteException(string2.length() != 0 ? "Database properties is missing required column: ".concat(string2) : new String("Database properties is missing required column: "));
            }
            if (!set.isEmpty()) {
                throw new SQLiteException("Database properties table has extra columns");
            }
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza(sQLiteDatabase, "hits2")) {
                sQLiteDatabase.execSQL(bo);
            } else {
                this.zza(sQLiteDatabase);
            }
            if (!this.zza(sQLiteDatabase, "properties")) {
                sQLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS properties ( app_uid INTEGER NOT NULL, cid TEXT NOT NULL, tid TEXT NOT NULL, params TEXT NOT NULL, adid INTEGER NOT NULL, hits_count INTEGER NOT NULL, PRIMARY KEY (app_uid, cid, tid)) ;");
            } else {
                this.zzb(sQLiteDatabase);
            }
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzx.zzfa(sQLiteDatabase.getPath());
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }
}

