/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzac;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.common.stats.zzb;
import java.util.Collections;
import java.util.List;

public class zzi
extends zzd {
    private final zza bf;
    private zzac bg;
    private final zzt bh;
    private zzal bi;

    protected zzi(zzf zzf2) {
        super(zzf2);
        this.bi = new zzal(zzf2.zzaan());
        this.bf = new zza();
        this.bh = new zzt(zzf2){

            @Override
            public void run() {
                zzi.this.zzabl();
            }
        };
    }

    @Override
    protected void zzym() {
    }

    public boolean isConnected() {
        this.zzyl();
        this.zzaax();
        return this.bg != null;
    }

    public boolean zzb(zzab zzab2) {
        com.google.android.gms.common.internal.zzac.zzy((Object)zzab2);
        this.zzyl();
        this.zzaax();
        zzac zzac2 = this.bg;
        if (zzac2 == null) {
            return false;
        }
        String string = zzab2.zzaes() ? this.zzaap().zzadh() : this.zzaap().zzadi();
        List<Command> list = Collections.emptyList();
        try {
            zzac2.zza(zzab2.zzm(), zzab2.zzaeq(), string, list);
            this.zzabk();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzep("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zzabj() {
        this.zzyl();
        this.zzaax();
        zzac zzac2 = this.bg;
        if (zzac2 == null) {
            return false;
        }
        try {
            zzac2.zzaaf();
            this.zzabk();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzep("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zzabk() {
        this.bi.start();
        this.bh.zzx(this.zzaap().zzado());
    }

    public boolean connect() {
        this.zzyl();
        this.zzaax();
        if (this.bg != null) {
            return true;
        }
        zzac zzac2 = this.bf.zzabm();
        if (zzac2 != null) {
            this.bg = zzac2;
            this.zzabk();
            return true;
        }
        return false;
    }

    private void zza(zzac zzac2) {
        this.zzyl();
        this.bg = zzac2;
        this.zzabk();
        this.zzxu().onServiceConnected();
    }

    public void disconnect() {
        this.zzyl();
        this.zzaax();
        try {
            zzb zzb2 = zzb.zzawu();
            zzb2.zza(this.getContext(), (ServiceConnection)this.bf);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.bg != null) {
            this.bg = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName componentName) {
        this.zzyl();
        if (this.bg != null) {
            this.bg = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.onDisconnect();
        }
    }

    private void zzabl() {
        this.zzyl();
        if (!this.isConnected()) {
            return;
        }
        this.zzep("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zzxu().zzaai();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzac bk;
        private volatile boolean bl;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzac zzabm() {
            zzi.this.zzyl();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzi.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            zzb zzb2 = zzb.zzawu();
            zza zza2 = this;
            synchronized (zza2) {
                this.bk = null;
                this.bl = true;
                boolean bl = zzb2.zza(context, intent, (ServiceConnection)zzi.this.bf, 129);
                zzi.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.bl = false;
                    return null;
                }
                try {
                    long l = zzi.this.zzaap().zzadp();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzi.this.zzes("Wait for service connect was interrupted");
                }
                this.bl = false;
                zzac zzac2 = this.bk;
                this.bk = null;
                if (zzac2 == null) {
                    zzi.this.zzet("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzac2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            com.google.android.gms.common.internal.zzac.zzhq((String)"AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (iBinder == null) {
                        zzi.this.zzet("Service connected with null binder");
                        return;
                    }
                    zzac zzac2 = null;
                    try {
                        object = iBinder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzac2 = zzac.zza.zzbm(iBinder);
                            zzi.this.zzep("Bound to IAnalyticsService interface");
                        } else {
                            zzi.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzi.this.zzet("Service connect failed to get IAnalyticsService");
                    }
                    if (zzac2 == null) {
                        try {
                            zzb.zzawu().zza(zzi.this.getContext(), (ServiceConnection)zzi.this.bf);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.bl) {
                        zzi.this.zzes("onServiceConnected received after the timeout limit");
                        object = zzac2;
                        zzi.this.zzaaq().zzg(new Runnable((zzac)object){
                            final /* synthetic */ zzac bm;
                            {
                                this.bm = zzac2;
                            }

                            @Override
                            public void run() {
                                if (!zzi.this.isConnected()) {
                                    zzi.this.zzeq("Connected to service after a timeout");
                                    zzi.this.zza(this.bm);
                                }
                            }
                        });
                    } else {
                        this.bk = zzac2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName componentName) {
            com.google.android.gms.common.internal.zzac.zzhq((String)"AnalyticsServiceConnection.onServiceDisconnected");
            zzi.this.zzaaq().zzg(new Runnable(){

                @Override
                public void run() {
                    zzi.this.onServiceDisconnected(componentName);
                }
            });
        }
    }
}

