/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzm;
import com.google.android.gms.analytics.internal.zzo;
import com.google.android.gms.common.internal.zzac;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

class zzah
extends zzd {
    private final String zzbnw = zzah.zza("GoogleAnalytics", zze.VERSION, Build.VERSION.RELEASE, zzao.zza(Locale.getDefault()), Build.MODEL, Build.ID);
    private final zzal dt;
    private static final byte[] du = "\n".getBytes();

    zzah(zzf zzf2) {
        super(zzf2);
        this.dt = new zzal(zzf2.zzaan());
    }

    @Override
    protected void zzym() {
        this.zza("Network initialized. User agent", this.zzbnw);
    }

    private static String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    public boolean zzafa() {
        this.zzyl();
        this.zzaax();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzep("No network connectivity");
            return false;
        }
        return true;
    }

    public List<Long> zzt(List<zzab> list) {
        boolean bl;
        boolean bl2;
        this.zzyl();
        this.zzaax();
        zzac.zzy(list);
        if (this.zzaap().zzadn().isEmpty() || !this.dt.zzz(this.zzaap().zzadg() * 1000L)) {
            bl2 = false;
            bl = false;
        } else {
            bl2 = this.zzaap().zzadl() != zzm.bG;
            boolean bl3 = bl = this.zzaap().zzadm() == zzo.bR;
        }
        if (bl2) {
            return this.zza(list, bl);
        }
        return this.zzu(list);
    }

    List<Long> zzu(List<zzab> list) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
        for (zzab zzab2 : list) {
            if (!this.zzg(zzab2)) break;
            arrayList.add(zzab2.zzaep());
            if (arrayList.size() < this.zzaap().zzade()) continue;
            break;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzb(URL uRL) {
        zzac.zzy((Object)uRL);
        this.zzb("GET request", uRL);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.connect();
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzxu().zzaak();
            }
            this.zzb("GET status", n);
            int n2 = n;
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network GET connection error", iOException);
            boolean bl = false;
            return 0;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zza(URL uRL, byte[] byArray) {
        zzac.zzy((Object)uRL);
        zzac.zzy((Object)byArray);
        this.zzb("POST bytes, url", byArray.length, uRL);
        if (this.zzue()) {
            this.zza("Post payload\n", new String(byArray));
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.zzfb(this.getContext().getPackageName());
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzxu().zzaak();
            }
            this.zzb("POST status", n);
            int n2 = n;
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network POST connection error", iOException);
            boolean bl = false;
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            this.zzsm();
        }
    }

    private static byte[] zzj(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzb(URL uRL, byte[] byArray) {
        int n;
        zzac.zzy((Object)uRL);
        zzac.zzy((Object)byArray);
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.zzfb(this.getContext().getPackageName());
            byte[] byArray2 = zzah.zzj(byArray);
            this.zza("POST compressed size, ratio %, url", byArray2.length, 100L * (long)byArray2.length / (long)byArray.length, uRL);
            if (byArray2.length > byArray.length) {
                this.zzc("Compressed payload is larger then uncompressed. compressed, uncompressed", byArray2.length, byArray.length);
            }
            if (this.zzue()) {
                String string = String.valueOf(new String(byArray));
                this.zza("Post payload", string.length() != 0 ? "\n".concat(string) : new String("\n"));
            }
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpURLConnection.setFixedLengthStreamingMode(byArray2.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray2);
            outputStream.close();
            outputStream = null;
            this.zzb(httpURLConnection);
            n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzxu().zzaak();
            }
            this.zzb("POST status", n);
            int n2 = n;
        }
        catch (IOException iOException) {
            this.zzd("Network compressed POST connection error", iOException);
            boolean bl = false;
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http compressed post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            this.zzsm();
        }
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        this.zzsm();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) > 0) {
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http connection input stream", iOException);
                }
            }
        }
    }

    HttpURLConnection zzc(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("Failed to obtain http connection");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setConnectTimeout(this.zzaap().zzadw());
        httpURLConnection.setReadTimeout(this.zzaap().zzadx());
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("User-Agent", this.zzbnw);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private boolean zzg(zzab zzab2) {
        zzac.zzy((Object)zzab2);
        String string = this.zza(zzab2, !zzab2.zzaes());
        if (string == null) {
            this.zzaao().zza(zzab2, "Error formatting hit for upload");
            return true;
        }
        if (string.length() <= this.zzaap().zzacw()) {
            URL uRL = this.zzb(zzab2, string);
            if (uRL == null) {
                this.zzet("Failed to build collect GET endpoint url");
                return false;
            }
            return this.zzb(uRL) == 200;
        }
        string = this.zza(zzab2, false);
        if (string == null) {
            this.zzaao().zza(zzab2, "Error formatting hit for POST upload");
            return true;
        }
        byte[] byArray = string.getBytes();
        if (byArray.length > this.zzaap().zzacy()) {
            this.zzaao().zza(zzab2, "Hit payload exceeds size limit");
            return true;
        }
        URL uRL = this.zzh(zzab2);
        if (uRL == null) {
            this.zzet("Failed to build collect POST endpoint url");
            return false;
        }
        return this.zza(uRL, byArray) == 200;
    }

    List<Long> zza(List<zzab> list, boolean bl) {
        zzac.zzbs((!list.isEmpty() ? 1 : 0) != 0);
        this.zza("Uploading batched hits. compression, count", bl, list.size());
        zza zza2 = new zza();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (zzab zzab2 : list) {
            if (!zza2.zzj(zzab2)) break;
            arrayList.add(zzab2.zzaep());
        }
        if (zza2.zzafd() == 0) {
            return arrayList;
        }
        URL uRL = this.zzafb();
        if (uRL == null) {
            this.zzet("Failed to build batching endpoint url");
            return Collections.emptyList();
        }
        int n = bl ? this.zzb(uRL, zza2.getPayload()) : this.zza(uRL, zza2.getPayload());
        if (200 == n) {
            this.zza("Batched upload completed. Hits batched", zza2.zzafd());
            return arrayList;
        }
        this.zza("Network error uploading hits. status code", n);
        if (this.zzaap().zzadn().contains(n)) {
            this.zzes("Server instructed the client to stop batching");
            this.dt.start();
        }
        return Collections.emptyList();
    }

    private URL zzh(zzab zzab2) {
        String string;
        if (zzab2.zzaes()) {
            String string2 = String.valueOf(this.zzaap().zzadh());
            String string3 = String.valueOf(this.zzaap().zzadj());
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        } else {
            String string4 = String.valueOf(this.zzaap().zzadi());
            String string5 = String.valueOf(this.zzaap().zzadj());
            string = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzb(zzab zzab2, String string) {
        String string2;
        String string3;
        if (zzab2.zzaes()) {
            string3 = String.valueOf(this.zzaap().zzadh());
            String string4 = String.valueOf(this.zzaap().zzadj());
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string).length()).append(string3).append(string4).append("?").append(string).toString();
        } else {
            string3 = String.valueOf(this.zzaap().zzadi());
            String string5 = String.valueOf(this.zzaap().zzadj());
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string5).length() + String.valueOf(string).length()).append(string3).append(string5).append("?").append(string).toString();
        }
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzafb() {
        String string = String.valueOf(this.zzaap().zzadh());
        String string2 = String.valueOf(this.zzaap().zzadk());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    String zza(zzab zzab2, boolean bl) {
        zzac.zzy((Object)zzab2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : zzab2.zzm().entrySet()) {
                String string = entry.getKey();
                if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string) || "z".equals(string) || "_gmsv".equals(string)) continue;
                this.zza(stringBuilder, string, entry.getValue());
            }
            this.zza(stringBuilder, "ht", String.valueOf(zzab2.zzaeq()));
            long l = this.zzaan().currentTimeMillis() - zzab2.zzaeq();
            this.zza(stringBuilder, "qt", String.valueOf(l));
            if (this.zzaap().zzact()) {
                this.zza(stringBuilder, "_gmsv", zze.VERSION);
            }
            if (bl) {
                long l2 = zzab2.zzaet();
                String string = l2 != 0L ? String.valueOf(l2) : this.zzi(zzab2);
                this.zza(stringBuilder, "z", string);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.zze("Failed to encode name or value", unsupportedEncodingException);
            return null;
        }
    }

    private void zza(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        if (stringBuilder.length() != 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append('=');
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
    }

    private String zzi(zzab zzab2) {
        return String.valueOf(zzab2.zzaep());
    }

    protected void zzfb(String string) {
    }

    protected void zzsm() {
    }

    private class zza {
        private int dv;
        private ByteArrayOutputStream dw = new ByteArrayOutputStream();

        public boolean zzj(zzab zzab2) {
            zzac.zzy((Object)zzab2);
            if (this.dv + 1 > zzah.this.zzaap().zzadf()) {
                return false;
            }
            String string = zzah.this.zza(zzab2, false);
            if (string == null) {
                zzah.this.zzaao().zza(zzab2, "Error formatting hit");
                return true;
            }
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            if (n > zzah.this.zzaap().zzacx()) {
                zzah.this.zzaao().zza(zzab2, "Hit size exceeds the maximum size limit");
                return true;
            }
            if (this.dw.size() > 0) {
                ++n;
            }
            if (this.dw.size() + n > zzah.this.zzaap().zzacz()) {
                return false;
            }
            try {
                if (this.dw.size() > 0) {
                    this.dw.write(du);
                }
                this.dw.write(byArray);
            }
            catch (IOException iOException) {
                zzah.this.zze("Failed to write payload when batching hits", iOException);
                return true;
            }
            ++this.dv;
            return true;
        }

        public int zzafd() {
            return this.dv;
        }

        public byte[] getPayload() {
            return this.dw.toByteArray();
        }
    }
}

