/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzb;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzac;

class zzag
extends BroadcastReceiver {
    static final String dq = zzag.class.getName();
    private final zzf aI;
    private boolean dr;
    private boolean ds;

    zzag(zzf zzf2) {
        zzac.zzy((Object)zzf2);
        this.aI = zzf2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzaey();
        String string = intent.getAction();
        this.aI.zzaao().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzafa();
            if (this.ds != bl) {
                this.ds = bl;
                this.zzxu().zzav(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(dq)) {
                this.zzxu().zzaaj();
            }
            return;
        }
        this.aI.zzaao().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zzaex() {
        this.zzaey();
        if (this.dr) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.ds = this.zzafa();
        this.aI.zzaao().zza("Registering connectivity change receiver. Network connected", this.ds);
        this.dr = true;
    }

    private void zzaey() {
        this.zzaao();
        this.zzxu();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.aI.zzaao().zzep("Unregistering connectivity change receiver");
        this.dr = false;
        this.ds = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzaao().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zzaez() {
        if (Build.VERSION.SDK_INT <= 10) {
            return;
        }
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(dq, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.dr;
    }

    public boolean isConnected() {
        if (!this.dr) {
            this.aI.zzaao().zzes("Connectivity unknown. Receiver not registered");
        }
        return this.ds;
    }

    protected boolean zzafa() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.aI.getContext();
    }

    private zzaf zzaao() {
        return this.aI.zzaao();
    }

    private zzb zzxu() {
        return this.aI.zzxu();
    }
}

