/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzad;
import com.google.android.gms.analytics.internal.zzan;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzmi;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzd {
    private boolean k;
    private final Map<String, String> zzbiq = new HashMap<String, String>();
    private final Map<String, String> l = new HashMap<String, String>();
    private final zzad m;
    private final zza n;
    private ExceptionReporter o;
    private zzan p;

    Tracker(zzf zzf2, String string, zzad zzad2) {
        super(zzf2);
        if (string != null) {
            this.zzbiq.put("&tid", string);
        }
        this.zzbiq.put("useSecure", "1");
        this.zzbiq.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.m = zzad2 == null ? new zzad("tracking", this.zzaan()) : zzad2;
        this.n = new zza(zzf2);
    }

    @Override
    protected void zzym() {
        String string;
        this.n.initialize();
        String string2 = this.zzxv().zzys();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzxv().zzyt()) != null) {
            this.set("&av", string);
        }
    }

    void zza(zzan zzan2) {
        String string;
        this.zzep("Loading Tracker config values");
        this.p = zzan2;
        if (this.p.zzafs()) {
            string = this.p.getTrackingId();
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.p.zzaft()) {
            string = Double.toString(this.p.zzafu());
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.p.zzafv()) {
            int n = this.p.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.p.zzafw()) {
            boolean bl = this.p.zzafx();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.p.zzafy()) {
            boolean bl = this.p.zzafz();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.p.zzaga());
    }

    private boolean zzyn() {
        return this.o != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzyn() == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.o = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.o);
                this.zzep("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.o.zzxp();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzep("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long l) {
        this.n.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.n.enableAutoActivityTracking(bl);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        String string2 = entry.getValue();
        return string.startsWith("&") && string.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzac.zzy(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzac.zzy(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        final long l = this.zzaan().currentTimeMillis();
        if (this.zzxo().getAppOptOut()) {
            this.zzeq("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zzxo().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzbiq, hashMap);
        Tracker.zzb(map, hashMap);
        final boolean bl2 = zzao.zzi(this.zzbiq.get("useSecure"), true);
        Tracker.zzc(this.l, hashMap);
        this.l.clear();
        final String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzaao().zzh(hashMap, "Missing hit type parameter");
            return;
        }
        final String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzaao().zzh(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zzyo();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzbiq.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzbiq.put("&a", Integer.toString(n));
            }
        }
        this.zzaaq().zzg(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.n.zzyp()) {
                    hashMap.put("sc", "start");
                }
                zzao.zzd(hashMap, "cid", Tracker.this.zzxo().zzxs());
                String string3 = (String)hashMap.get("sf");
                if (string3 != null && zzao.zza(d = zzao.zza(string3, 100.0), (String)hashMap.get("cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                com.google.android.gms.analytics.internal.zza zza2 = Tracker.this.zzaau();
                if (bl3) {
                    zzao.zzb(hashMap, "ate", zza2.zzzq());
                    zzao.zzc(hashMap, "adid", zza2.zzaab());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zzmi zzmi2 = Tracker.this.zzaav().zzabu();
                zzao.zzc(hashMap, "an", zzmi2.zzys());
                zzao.zzc(hashMap, "av", zzmi2.zzyt());
                zzao.zzc(hashMap, "aid", zzmi2.zzti());
                zzao.zzc(hashMap, "aiid", zzmi2.zzyu());
                hashMap.put("v", "1");
                hashMap.put("_v", zze.aK);
                zzao.zzc(hashMap, "ul", Tracker.this.zzaaw().zzaeb().getLanguage());
                zzao.zzc(hashMap, "sr", Tracker.this.zzaaw().zzaec());
                boolean bl22 = bl4 = string.equals("transaction") || string.equals("item");
                if (!bl4 && !Tracker.this.m.zzaev()) {
                    Tracker.this.zzaao().zzh(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zzao.zzfg((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzab zzab2 = new zzab(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zzaao().zzc("Dry run enabled. Would have sent hit", zzab2);
                    return;
                }
                String string22 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zzao.zza(hashMap2, "uid", hashMap);
                zzao.zza(hashMap2, "an", hashMap);
                zzao.zza(hashMap2, "aid", hashMap);
                zzao.zza(hashMap2, "av", hashMap);
                zzao.zza(hashMap2, "aiid", hashMap);
                zzh zzh2 = new zzh(0L, string22, string2, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zzxu().zza(zzh2);
                hashMap.put("_s", String.valueOf(l2));
                zzab zzab3 = new zzab(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zzxu().zza(zzab3);
            }
        });
    }

    public String get(String string) {
        this.zzaax();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzbiq.containsKey(string)) {
            return this.zzbiq.get(string);
        }
        if (string.equals("&ul")) {
            return zzao.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzaat().zzacm();
        }
        if (string.equals("&sr")) {
            return this.zzaaw().zzaec();
        }
        if (string.equals("&aid")) {
            return this.zzaav().zzabu().zzti();
        }
        if (string.equals("&an")) {
            return this.zzaav().zzabu().zzys();
        }
        if (string.equals("&av")) {
            return this.zzaav().zzabu().zzyt();
        }
        if (string.equals("&aiid")) {
            return this.zzaav().zzabu().zzyu();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzac.zzb((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzbiq.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzao.zzaw(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzes("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzao.zzaw(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.l.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.l.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.l.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.l.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.l.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.l.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.l.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.l.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.l.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.l.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.k = bl;
    }

    boolean zzyo() {
        return this.k;
    }

    static String zzq(Activity activity) {
        zzac.zzy((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    extends zzd
    implements GoogleAnalytics.zza {
        private boolean A;
        private int B;
        private long C;
        private boolean D;
        private long E;

        protected zza(zzf zzf2) {
            super(zzf2);
            this.C = -1L;
        }

        @Override
        protected void zzym() {
        }

        public void setSessionTimeout(long l) {
            this.C = l;
            this.zzyq();
        }

        public void enableAutoActivityTracking(boolean bl) {
            this.A = bl;
            this.zzyq();
        }

        public synchronized boolean zzyp() {
            boolean bl = this.D;
            this.D = false;
            return bl;
        }

        private void zzyq() {
            if (this.C >= 0L || this.A) {
                this.zzxo().zza(Tracker.this.n);
            } else {
                this.zzxo().zzb(Tracker.this.n);
            }
        }

        @Override
        public void zzo(Activity activity) {
            if (this.B == 0 && this.zzyr()) {
                this.D = true;
            }
            ++this.B;
            if (this.A) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.p != null ? Tracker.this.p.zzr(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzq(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzp(Activity activity) {
            --this.B;
            this.B = Math.max(0, this.B);
            if (this.B == 0) {
                this.E = this.zzaan().elapsedRealtime();
            }
        }

        boolean zzyr() {
            return this.zzaan().elapsedRealtime() >= this.E + Math.max(1000L, this.C);
        }
    }
}

