/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.internal.zzae;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class StandardExceptionParser
implements ExceptionParser {
    private final TreeSet<String> j = new TreeSet();

    public StandardExceptionParser(Context context, Collection<String> collection) {
        this.setIncludedPackages(context, collection);
    }

    public void setIncludedPackages(Context context, Collection<String> collection) {
        this.j.clear();
        HashSet<String> hashSet = new HashSet<String>();
        if (collection != null) {
            hashSet.addAll(collection);
        }
        if (context != null) {
            try {
                String string = context.getApplicationContext().getPackageName();
                this.j.add(string);
                String string2 = context.getApplicationContext().getPackageManager().getPackageInfo(string, 1);
                ActivityInfo[] activityInfoArray = ((PackageInfo)string2).activities;
                if (activityInfoArray != null) {
                    for (ActivityInfo activityInfo : activityInfoArray) {
                        hashSet.add(activityInfo.packageName);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                zzae.zzde("No package found");
            }
        }
        for (String string2 : hashSet) {
            boolean bl = true;
            for (String string : this.j) {
                if (!string2.startsWith(string)) {
                    if (!string.startsWith(string2)) break;
                    this.j.remove(string);
                    break;
                }
                bl = false;
            }
            if (!bl) continue;
            this.j.add(string2);
        }
    }

    protected Throwable getCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    protected StackTraceElement getBestStackTraceElement(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return null;
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string = stackTraceElement.getClassName();
            for (String string2 : this.j) {
                if (!string.startsWith(string2)) continue;
                return stackTraceElement;
            }
        }
        return stackTraceElementArray[0];
    }

    protected String getDescription(Throwable throwable, StackTraceElement stackTraceElement, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(throwable.getClass().getSimpleName());
        if (stackTraceElement != null) {
            String[] stringArray = stackTraceElement.getClassName().split("\\.");
            String string2 = "unknown";
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[stringArray.length - 1];
            }
            stringBuilder.append(String.format(" (@%s:%s:%s)", string2, stackTraceElement.getMethodName(), stackTraceElement.getLineNumber()));
        }
        if (string != null) {
            stringBuilder.append(String.format(" {%s}", string));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDescription(String string, Throwable throwable) {
        return this.getDescription(this.getCause(throwable), this.getBestStackTraceElement(this.getCause(throwable)), string);
    }
}

