/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzan;
import com.google.android.gms.analytics.internal.zzap;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.common.internal.zzac;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzcyx = new ArrayList<Runnable>();
    private boolean zzaom;
    private Set<zza> zzcyy = new HashSet<zza>();
    private boolean zzcyz;
    private boolean zzcza;
    private volatile boolean zzczb;
    private boolean zzczc;

    public void initialize() {
        this.zzxq();
        this.zzaom = true;
    }

    void zzxq() {
        Logger logger;
        zzap zzap2 = this.zzxv();
        if (zzap2.zzaei()) {
            this.getLogger().setLogLevel(zzap2.getLogLevel());
        }
        if (zzap2.zzaem()) {
            this.setDryRun(zzap2.zzaen());
        }
        if (zzap2.zzaei() && (logger = zzae.getLogger()) != null) {
            logger.setLogLevel(zzap2.getLogLevel());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInitialized() {
        if (!this.zzaom) return false;
        if (false) return false;
        return true;
    }

    public GoogleAnalytics(zzf zzf2) {
        super(zzf2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzf.zzaz(context).zzabb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzxr() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzcyx != null) {
                for (Runnable runnable : zzcyx) {
                    runnable.run();
                }
                zzcyx = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean bl) {
        this.zzcza = bl;
    }

    public boolean isDryRunEnabled() {
        return this.zzcza;
    }

    @TargetApi(value=14)
    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzcyz) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzcyz = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzcyz) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzcyy) {
            zza2.zzo(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzcyz) {
            this.zzn(activity);
        }
    }

    void zzn(Activity activity) {
        for (zza zza2 : this.zzcyy) {
            zza2.zzp(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzxh(), string, null);
            tracker.initialize();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzam zzam2;
            zzan zzan2;
            Tracker tracker = new Tracker(this.zzxh(), null, null);
            if (n > 0 && (zzan2 = (zzan)(zzam2 = new zzam(this.zzxh())).zzcd(n)) != null) {
                tracker.zza(zzan2);
            }
            tracker.initialize();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzcyy.add(zza2);
        Context context = this.zzxh().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzcyy.remove(zza2);
    }

    public void setAppOptOut(boolean bl) {
        this.zzczb = bl;
        if (this.zzczb) {
            this.zzxu().zzaaf();
        }
    }

    public boolean getAppOptOut() {
        return this.zzczb;
    }

    @Deprecated
    public Logger getLogger() {
        return zzae.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zzae.setLogger(logger);
        if (!this.zzczc) {
            String string = zzy.cg.get();
            Log.i((String)zzy.cg.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzczc = true;
        }
    }

    public String zzxs() {
        zzac.zzhr((String)"getClientId can not be called from the main thread");
        return this.zzxh().zzabe().zzacm();
    }

    public void setLocalDispatchPeriod(int n) {
        this.zzxu().setLocalDispatchPeriod(n);
    }

    public void dispatchLocalHits() {
        this.zzxu().zzaag();
    }

    void zzxt() {
        this.zzxu().zzaah();
    }

    private com.google.android.gms.analytics.internal.zzb zzxu() {
        return this.zzxh().zzxu();
    }

    private zzap zzxv() {
        return this.zzxh().zzxv();
    }

    @TargetApi(value=14)
    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzn(activity);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzo(Activity var1);

        public void zzp(Activity var1);
    }
}

