/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzcyt;
    private final Tracker zzcyu;
    private final Context mContext;
    private ExceptionParser zzcyv;
    private GoogleAnalytics zzcyw;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzcyt = uncaughtExceptionHandler;
        this.zzcyu = tracker;
        this.zzcyv = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        String string = String.valueOf(uncaughtExceptionHandler == null ? "null" : uncaughtExceptionHandler.getClass().getName());
        zzae.v(string.length() != 0 ? "ExceptionReporter created, original handler is ".concat(string) : new String("ExceptionReporter created, original handler is "));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzcyv;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzcyv = exceptionParser;
    }

    GoogleAnalytics zzxo() {
        if (this.zzcyw == null) {
            this.zzcyw = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzcyw;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Object object;
        String string = "UncaughtException";
        if (this.zzcyv != null) {
            object = thread != null ? thread.getName() : null;
            string = this.zzcyv.getDescription((String)object, throwable);
        }
        String string2 = String.valueOf(string);
        zzae.v(string2.length() != 0 ? "Reporting uncaught exception: ".concat(string2) : new String("Reporting uncaught exception: "));
        this.zzcyu.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        object = this.zzxo();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zzxt();
        if (this.zzcyt != null) {
            zzae.v("Passing exception to the original handler");
            this.zzcyt.uncaughtException(thread, throwable);
        }
    }

    Thread.UncaughtExceptionHandler zzxp() {
        return this.zzcyt;
    }
}

