/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzxb;

public class CampaignTrackingService
extends Service {
    private Handler mHandler;
    private static Boolean zzcyp;

    public static boolean zzax(Context context) {
        zzac.zzy((Object)context);
        if (zzcyp != null) {
            return zzcyp;
        }
        boolean bl = zzao.zzq(context, "com.google.android.gms.analytics.CampaignTrackingService");
        zzcyp = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onCreate() {
        super.onCreate();
        zzf zzf2 = zzf.zzaz((Context)this);
        zzaf zzaf2 = zzf2.zzaao();
        zzaf2.zzep("CampaignTrackingService is starting up");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onDestroy() {
        zzf zzf2 = zzf.zzaz((Context)this);
        zzaf zzaf2 = zzf2.zzaao();
        zzaf2.zzep("CampaignTrackingService is shutting down");
        super.onDestroy();
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public int onStartCommand(Intent intent, int n, final int n2) {
        String string;
        this.zzxn();
        zzf zzf2 = zzf.zzaz((Context)this);
        final zzaf zzaf2 = zzf2.zzaao();
        String string2 = null;
        if (zzf2.zzaap().zzact()) {
            zzaf2.zzet("Unexpected installation campaign (package side)");
        } else {
            string2 = intent.getStringExtra("referrer");
        }
        final Handler handler = this.getHandler();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!zzf2.zzaap().zzact()) {
                zzaf2.zzes("No campaign found on com.android.vending.INSTALL_REFERRER \"referrer\" extra");
            }
            zzf2.zzaaq().zzg(new Runnable(){

                @Override
                public void run() {
                    CampaignTrackingService.this.zza(zzaf2, handler, n2);
                }
            });
            return 2;
        }
        int n3 = zzf2.zzaap().zzacx();
        if (string2.length() <= n3) {
            string = string2;
        } else {
            zzaf2.zzc("Campaign data exceed the maximum supported size and will be clipped. size, limit", string2.length(), n3);
            string = string2.substring(0, n3);
        }
        zzaf2.zza("CampaignTrackingService called. startId, campaign", n2, string);
        zzf2.zzxu().zza(string, new Runnable(){

            @Override
            public void run() {
                CampaignTrackingService.this.zza(zzaf2, handler, n2);
            }
        });
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzxn() {
        try {
            Object object = CampaignTrackingReceiver.zzaok;
            synchronized (object) {
                zzxb zzxb2 = CampaignTrackingReceiver.zzcyn;
                if (zzxb2 != null && zzxb2.isHeld()) {
                    zzxb2.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected void zza(final zzaf zzaf2, Handler handler, final int n) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                boolean bl = CampaignTrackingService.this.stopSelfResult(n);
                if (bl) {
                    zzaf2.zza("Install campaign broadcast processed", bl);
                }
            }
        });
    }

    private Handler getHandler() {
        Handler handler = this.mHandler;
        if (handler == null) {
            this.mHandler = handler = new Handler(this.getMainLooper());
        }
        return handler;
    }
}

