/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzxb;

public class CampaignTrackingReceiver
extends BroadcastReceiver {
    static Object zzaok = new Object();
    static zzxb zzcyn;
    static Boolean zzcyo;

    public static boolean zzaw(Context context) {
        zzac.zzy((Object)context);
        if (zzcyo != null) {
            return zzcyo;
        }
        boolean bl = zzao.zza(context, "com.google.android.gms.analytics.CampaignTrackingReceiver", true);
        zzcyo = bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onReceive(Context context, Intent intent) {
        zzf zzf2 = zzf.zzaz(context);
        zzaf zzaf2 = zzf2.zzaao();
        if (intent == null) {
            zzaf2.zzes("CampaignTrackingReceiver received null intent");
            return;
        }
        String string = intent.getStringExtra("referrer");
        String string2 = intent.getAction();
        zzaf2.zza("CampaignTrackingReceiver received", (Object)string2);
        if (!"com.android.vending.INSTALL_REFERRER".equals(string2) || TextUtils.isEmpty((CharSequence)string)) {
            zzaf2.zzes("CampaignTrackingReceiver received unexpected intent without referrer extra");
            return;
        }
        boolean bl = CampaignTrackingService.zzax(context);
        if (!bl) {
            zzaf2.zzes("CampaignTrackingService not registered or disabled. Installation tracking not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzo(context, string);
        if (zzf2.zzaap().zzact()) {
            zzaf2.zzet("Received unexpected installation campaign on package side");
            return;
        }
        Class<? extends CampaignTrackingService> clazz = this.zzxm();
        zzac.zzy(clazz);
        Intent intent2 = new Intent(context, clazz);
        intent2.putExtra("referrer", string);
        Object object = zzaok;
        synchronized (object) {
            context.startService(intent2);
            if (!bl) {
                return;
            }
            try {
                if (zzcyn == null) {
                    zzcyn = new zzxb(context, 1, "Analytics campaign WakeLock");
                    zzcyn.setReferenceCounted(false);
                }
                zzcyn.acquire(1000L);
            }
            catch (SecurityException securityException) {
                zzaf2.zzes("CampaignTrackingService service at risk of not starting. For more reliable installation campaign reports, add the WAKE_LOCK permission to your manifest. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    protected Class<? extends CampaignTrackingService> zzxm() {
        return CampaignTrackingService.class;
    }

    protected void zzo(Context context, String string) {
    }
}

