/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzt
extends zzaa {
    static final Pair<String, Long> apO = new Pair((Object)"", (Object)0L);
    private SharedPreferences dy;
    public final zzc apP = new zzc("health_monitor", this.zzbvi().zzadz());
    public final zzb apQ = new zzb("last_upload", 0L);
    public final zzb apR = new zzb("last_upload_attempt", 0L);
    public final zzb apS = new zzb("backoff", 0L);
    public final zzb apT = new zzb("last_delete_stale", 0L);
    public final zzb apU;
    private String apV;
    private boolean apW;
    private long apX;
    private SecureRandom apY;
    public final zzb apZ = new zzb("time_before_start", 10000L);
    public final zzb aqa = new zzb("session_timeout", 1800000L);
    public final zza aqb = new zza("start_new_session", true);
    public final zzb aqc = new zzb("last_pause_time", 0L);
    public final zzb aqd = new zzb("time_active", 0L);
    public boolean aqe;

    @WorkerThread
    private SecureRandom zzbwl() {
        this.zzyl();
        if (this.apY == null) {
            this.apY = new SecureRandom();
        }
        return this.apY;
    }

    @WorkerThread
    @NonNull
    Pair<String, Boolean> zzml(String string) {
        this.zzyl();
        long l = this.zzaan().elapsedRealtime();
        if (this.apV != null && l < this.apX) {
            return new Pair((Object)this.apV, (Object)this.apW);
        }
        this.apX = l + this.zzbvi().zzlr(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.apV = info.getId();
            if (this.apV == null) {
                this.apV = "";
            }
            this.apW = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzbvg().zzbwi().zzj("Unable to get advertising id", throwable);
            this.apV = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.apV, (Object)this.apW);
    }

    String zzmm(String string) {
        String string2 = (String)this.zzml((String)string).first;
        MessageDigest messageDigest = zzal.zzfi("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    @WorkerThread
    String zzbwm() {
        byte[] byArray = new byte[16];
        this.zzbwl().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    String zzbst() {
        this.zzyl();
        try {
            return com.google.firebase.iid.zzc.A().getId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzbvg().zzbwe().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    @WorkerThread
    long zzbwn() {
        this.zzaax();
        this.zzyl();
        long l = this.apU.get();
        if (l == 0L) {
            l = 1 + this.zzbwl().nextInt(86400000);
            this.apU.set(l);
        }
        return l;
    }

    zzt(zzx zzx2) {
        super(zzx2);
        this.apU = new zzb("midnight_offset", 0L);
    }

    @Override
    protected void zzym() {
        this.dy = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.aqe = this.dy.getBoolean("has_been_opened", false);
        if (!this.aqe) {
            SharedPreferences.Editor editor = this.dy.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzbwo() {
        this.zzyl();
        this.zzaax();
        return this.dy;
    }

    @WorkerThread
    void zzmn(String string) {
        this.zzyl();
        SharedPreferences.Editor editor = this.zzbwo().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    String zzbwp() {
        this.zzyl();
        return this.zzbwo().getString("gmp_app_id", null);
    }

    @WorkerThread
    Boolean zzbwq() {
        this.zzyl();
        if (!this.zzbwo().contains("use_service")) {
            return null;
        }
        return this.zzbwo().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzcf(boolean bl) {
        this.zzyl();
        this.zzbvg().zzbwj().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzbwo().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    void zzbwr() {
        this.zzyl();
        this.zzbvg().zzbwj().log("Clearing collection preferences.");
        boolean bl = this.zzbwo().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzcg(true);
        }
        SharedPreferences.Editor editor = this.zzbwo().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    void setMeasurementEnabled(boolean bl) {
        this.zzyl();
        this.zzbvg().zzbwj().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzbwo().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzcg(boolean bl) {
        this.zzyl();
        return this.zzbwo().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected String zzbws() {
        this.zzyl();
        String string = this.zzbwo().getString("previous_os_version", null);
        String string2 = this.zzbuz().zzbvv();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzbwo().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    public final class zza {
        private final String zzbaf;
        private final boolean aqf;
        private boolean aqg;
        private boolean vu;

        public zza(String string, boolean bl) {
            zzac.zzhz((String)string);
            this.zzbaf = string;
            this.aqf = bl;
        }

        @WorkerThread
        private void zzbwt() {
            if (this.aqg) {
                return;
            }
            this.aqg = true;
            this.vu = zzt.this.dy.getBoolean(this.zzbaf, this.aqf);
        }

        @WorkerThread
        public boolean get() {
            this.zzbwt();
            return this.vu;
        }

        @WorkerThread
        public void set(boolean bl) {
            SharedPreferences.Editor editor = zzt.this.dy.edit();
            editor.putBoolean(this.zzbaf, bl);
            editor.apply();
            this.vu = bl;
        }
    }

    public final class zzb {
        private final String zzbaf;
        private final long aqi;
        private boolean aqg;
        private long X;

        public zzb(String string, long l) {
            zzac.zzhz((String)string);
            this.zzbaf = string;
            this.aqi = l;
        }

        @WorkerThread
        private void zzbwt() {
            if (this.aqg) {
                return;
            }
            this.aqg = true;
            this.X = zzt.this.dy.getLong(this.zzbaf, this.aqi);
        }

        @WorkerThread
        public long get() {
            this.zzbwt();
            return this.X;
        }

        @WorkerThread
        public void set(long l) {
            SharedPreferences.Editor editor = zzt.this.dy.edit();
            editor.putLong(this.zzbaf, l);
            editor.apply();
            this.X = l;
        }
    }

    public final class zzc {
        final String aqj;
        private final String aqk;
        private final String aql;
        private final long dC;

        private zzc(String string, long l) {
            zzac.zzhz((String)string);
            zzac.zzbs((l > 0L ? 1 : 0) != 0);
            this.aqj = String.valueOf(string).concat(":start");
            this.aqk = String.valueOf(string).concat(":count");
            this.aql = String.valueOf(string).concat(":value");
            this.dC = l;
        }

        @WorkerThread
        private void zzafk() {
            zzt.this.zzyl();
            long l = zzt.this.zzaan().currentTimeMillis();
            SharedPreferences.Editor editor = zzt.this.dy.edit();
            editor.remove(this.aqk);
            editor.remove(this.aql);
            editor.putLong(this.aqj, l);
            editor.apply();
        }

        @WorkerThread
        private long zzafl() {
            zzt.this.zzyl();
            long l = this.zzafn();
            if (l == 0L) {
                this.zzafk();
                return 0L;
            }
            return Math.abs(l - zzt.this.zzaan().currentTimeMillis());
        }

        @WorkerThread
        public void zzfd(String string) {
            this.zzi(string, 1L);
        }

        @WorkerThread
        public void zzi(String string, long l) {
            long l2;
            zzt.this.zzyl();
            long l3 = this.zzafn();
            if (l3 == 0L) {
                this.zzafk();
            }
            if (string == null) {
                string = "";
            }
            if ((l2 = zzt.this.dy.getLong(this.aqk, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzt.this.dy.edit();
                editor.putString(this.aql, string);
                editor.putLong(this.aqk, l);
                editor.apply();
                return;
            }
            long l4 = zzt.this.zzbwl().nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzt.this.dy.edit();
            if (bl) {
                editor.putString(this.aql, string);
            }
            editor.putLong(this.aqk, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzafm() {
            zzt.this.zzyl();
            long l = this.zzafl();
            if (l < this.dC) {
                return null;
            }
            if (l > this.dC * 2L) {
                this.zzafk();
                return null;
            }
            String string = zzt.this.zzbwo().getString(this.aql, null);
            long l2 = zzt.this.zzbwo().getLong(this.aqk, 0L);
            this.zzafk();
            if (string == null || l2 <= 0L) {
                return apO;
            }
            return new Pair((Object)string, (Object)l2);
        }

        @WorkerThread
        private long zzafn() {
            return zzt.this.zzbwo().getLong(this.aqj, 0L);
        }
    }
}

