/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzarc;
import com.google.android.gms.internal.zzard;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzvk;
import com.google.android.gms.internal.zzvm;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zze
extends zzaa {
    private static final Map<String, String> aoa = new ArrayMap(17);
    private static final Map<String, String> aob;
    private static final Map<String, String> aoc;
    private final zzc aod;
    private final zzah aoe = new zzah(this.zzaan());

    zze(zzx zzx2) {
        super(zzx2);
        String string = this.zzabs();
        this.aod = new zzc(this.getContext(), string);
    }

    @Override
    protected void zzym() {
    }

    @WorkerThread
    public void beginTransaction() {
        this.zzaax();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public void setTransactionSuccessful() {
        this.zzaax();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public void endTransaction() {
        this.zzaax();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzbvg().zzbwc().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l;
        }
    }

    @WorkerThread
    SQLiteDatabase getWritableDatabase() {
        this.zzyl();
        try {
            return this.aod.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwe().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    String zzabs() {
        if (!this.zzbvi().zzact()) {
            return this.zzbvi().zzadt();
        }
        if (this.zzbvi().zzacu()) {
            return this.zzbvi().zzadt();
        }
        this.zzbvg().zzbwf().log("Using secondary database");
        return this.zzbvi().zzadu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzi zzaq(String string, String string2) {
        zzac.zzhz((String)string);
        zzac.zzhz((String)string2);
        this.zzyl();
        this.zzaax();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var5_6 = null;
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzi zzi2 = new zzi(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzbvg().zzbwc().log("Got multiple records for event aggregates, expected one");
            }
            zzi zzi3 = zzi2;
            return zzi3;
        }
    }

    @WorkerThread
    public void zza(zzi zzi2) {
        zzac.zzy((Object)zzi2);
        this.zzyl();
        this.zzaax();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzi2.zzcpe);
        contentValues.put("name", zzi2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzi2.aot));
        contentValues.put("current_bundle_count", Long.valueOf(zzi2.aou));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzi2.aov));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("events", null, contentValues, 5);
            if (l == -1L) {
                this.zzbvg().zzbwc().log("Failed to insert/update event aggregates (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing event aggregates", (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzar(String string, String string2) {
        zzac.zzhz((String)string);
        zzac.zzhz((String)string2);
        this.zzyl();
        this.zzaax();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzbvg().zzbwj().zzj("Deleted user attribute rows:", n);
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzd("Error deleting user attribute", string, string2, (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzz(String string, int n) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaax();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string, string, String.valueOf(n)});
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zze("Error pruning currencies", string, (Object)sQLiteException);
        }
    }

    @WorkerThread
    public boolean zza(zzak zzak2) {
        long l;
        zzac.zzy((Object)zzak2);
        this.zzyl();
        this.zzaax();
        zzak zzak3 = this.zzas(zzak2.zzcpe, zzak2.mName);
        if (zzak3 == null && (zzal.zzmx(zzak2.mName) ? (l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzak2.zzcpe})) >= (long)this.zzbvi().zzbtx() : (l = this.zzb("select count(1) from user_attributes where app_id=?", new String[]{zzak2.zzcpe})) >= (long)this.zzbvi().zzbty())) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzak2.zzcpe);
        contentValues.put("name", zzak2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzak2.asy));
        this.zza(contentValues, "value", zzak2.zzctv);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l2 = sQLiteDatabase.insertWithOnConflict("user_attributes", null, contentValues, 5);
            if (l2 == -1L) {
                this.zzbvg().zzbwc().log("Failed to insert/update user property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing user property", (Object)sQLiteException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzak zzas(String string, String string2) {
        zzac.zzhz((String)string);
        zzac.zzhz((String)string2);
        this.zzyl();
        this.zzaax();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"set_timestamp", "value"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var5_6 = null;
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zzb(cursor, 1);
            zzak zzak2 = new zzak(string, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzbvg().zzbwc().log("Got multiple records for user property, expected one");
            }
            zzak zzak3 = zzak2;
            return zzak3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<zzak> zzly(String string) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaax();
        ArrayList<zzak> arrayList = new ArrayList<zzak>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"name", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(this.zzbvi().zzbty()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzak> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zzb(cursor, 2);
                if (object2 == null) {
                    this.zzbvg().zzbwc().log("Read invalid user property value, ignoring it");
                    continue;
                }
                zzak zzak2 = new zzak(string, (String)object, l, object2);
                arrayList.add(zzak2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public com.google.android.gms.measurement.internal.zza zzlz(String string) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaax();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_5 = null;
                return null;
            }
            com.google.android.gms.measurement.internal.zza zza2 = new com.google.android.gms.measurement.internal.zza(this.anq, string);
            zza2.zzlj(cursor.getString(0));
            zza2.zzlk(cursor.getString(1));
            zza2.zzll(cursor.getString(2));
            zza2.zzbb(cursor.getLong(3));
            zza2.zzaw(cursor.getLong(4));
            zza2.zzax(cursor.getLong(5));
            zza2.setAppVersion(cursor.getString(6));
            zza2.zzln(cursor.getString(7));
            zza2.zzaz(cursor.getLong(8));
            zza2.zzba(cursor.getLong(9));
            zza2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zza2.zzbe(cursor.getLong(11));
            zza2.zzbf(cursor.getLong(12));
            zza2.zzbg(cursor.getLong(13));
            zza2.zzbh(cursor.getLong(14));
            zza2.zzbc(cursor.getLong(15));
            zza2.zzbd(cursor.getLong(16));
            zza2.zzay(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zza2.zzlm(cursor.getString(18));
            zza2.zzbj(cursor.getLong(19));
            zza2.zzbi(cursor.getLong(20));
            zza2.zzbsq();
            if (cursor.moveToNext()) {
                this.zzbvg().zzbwc().log("Got multiple records for app, expected one");
            }
            com.google.android.gms.measurement.internal.zza zza3 = zza2;
            return zza3;
        }
    }

    @WorkerThread
    public void zza(com.google.android.gms.measurement.internal.zza zza2) {
        zzac.zzy((Object)zza2);
        this.zzyl();
        this.zzaax();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zza2.zzti());
        contentValues.put("app_instance_id", zza2.zzayn());
        contentValues.put("gmp_app_id", zza2.zzbsr());
        contentValues.put("resettable_device_id_hash", zza2.zzbss());
        contentValues.put("last_bundle_index", Long.valueOf(zza2.zzbtb()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zza2.zzbsu()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zza2.zzbsv()));
        contentValues.put("app_version", zza2.zzyt());
        contentValues.put("app_store", zza2.zzbsx());
        contentValues.put("gmp_version", Long.valueOf(zza2.zzbsy()));
        contentValues.put("dev_cert_hash", Long.valueOf(zza2.zzbsz()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zza2.zzbta()));
        contentValues.put("day", Long.valueOf(zza2.zzbtf()));
        contentValues.put("daily_public_events_count", Long.valueOf(zza2.zzbtg()));
        contentValues.put("daily_events_count", Long.valueOf(zza2.zzbth()));
        contentValues.put("daily_conversions_count", Long.valueOf(zza2.zzbti()));
        contentValues.put("config_fetched_time", Long.valueOf(zza2.zzbtc()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zza2.zzbtd()));
        contentValues.put("app_version_int", Long.valueOf(zza2.zzbsw()));
        contentValues.put("firebase_instance_id", zza2.zzbst());
        contentValues.put("daily_error_events_count", Long.valueOf(zza2.zzbtk()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zza2.zzbtj()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5);
            if (l == -1L) {
                this.zzbvg().zzbwc().log("Failed to insert/update app (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing app", (Object)sQLiteException);
        }
    }

    public long zzma(String string) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaax();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = String.valueOf(this.zzbvi().zzlx(string));
            long l = sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string2});
            return l;
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error deleting over the limit events", (Object)sQLiteException);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zza zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaax();
        String[] stringArray = new String[]{string};
        zza zza2 = new zza();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzbvg().zzbwe().zzj("Not updating daily counts, app is not known", string);
                zza zza3 = zza2;
                return zza3;
            }
            long l2 = cursor.getLong(0);
            if (l2 == l) {
                zza2.aog = cursor.getLong(1);
                zza2.aof = cursor.getLong(2);
                zza2.aoh = cursor.getLong(3);
                zza2.aoi = cursor.getLong(4);
                zza2.aoj = cursor.getLong(5);
            }
            if (bl) {
                ++zza2.aog;
            }
            if (bl2) {
                ++zza2.aof;
            }
            if (bl3) {
                ++zza2.aoh;
            }
            if (bl4) {
                ++zza2.aoi;
            }
            if (bl5) {
                ++zza2.aoj;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zza2.aof));
            contentValues.put("daily_events_count", Long.valueOf(zza2.aog));
            contentValues.put("daily_conversions_count", Long.valueOf(zza2.aoh));
            contentValues.put("daily_error_events_count", Long.valueOf(zza2.aoi));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zza2.aoj));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zza zza4 = zza2;
            return zza4;
        }
    }

    @WorkerThread
    public void zzd(String string, byte[] byArray) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaax();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string});
            if (l == 0L) {
                this.zzbvg().zzbwc().log("Failed to update remote config (got 0)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing remote config", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zzmb(String string) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaax();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_5 = null;
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzbvg().zzbwc().log("Got multiple records for app config, expected one");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public void zza(zzvm.zze zze2, boolean bl) {
        byte[] byArray;
        Object object;
        this.zzyl();
        this.zzaax();
        zzac.zzy((Object)((Object)zze2));
        zzac.zzhz((String)zze2.zzck);
        zzac.zzy((Object)zze2.atA);
        this.zzbvl();
        long l = this.zzaan().currentTimeMillis();
        if (zze2.atA < l - this.zzbvi().zzbue() || zze2.atA > l + this.zzbvi().zzbue()) {
            this.zzbvg().zzbwe().zze("Storing bundle outside of the max uploading time span. now, timestamp", l, zze2.atA);
        }
        try {
            int n = zze2.db();
            object = new byte[n];
            zzard zzard2 = zzard.zzbe((byte[])object);
            zze2.zza(zzard2);
            zzard2.cO();
            byArray = this.zzbvc().zzj((byte[])object);
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Data loss. Failed to serialize bundle", iOException);
            return;
        }
        this.zzbvg().zzbwj().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzck);
        contentValues.put("bundle_end_timestamp", zze2.atA);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            object = this.getWritableDatabase();
            long l2 = object.insert("queue", null, contentValues);
            if (l2 == -1L) {
                this.zzbvg().zzbwc().log("Failed to insert bundle (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing bundle", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public String zzbvj() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue where app_id not in (select app_id from apps where measurement_enabled=0) order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            Object var4_6 = null;
            return null;
        }
    }

    public boolean zzbvk() {
        long l = this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null);
        return l != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<Pair<zzvm.zze, Long>> zzn(String string, int n, int n2) {
        this.zzyl();
        this.zzaax();
        zzac.zzbs((n > 0 ? 1 : 0) != 0);
        zzac.zzbs((n2 > 0 ? 1 : 0) != 0);
        zzac.zzhz((String)string);
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzvm.zze, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzvm.zze, Long>> arrayList = new ArrayList<Pair<zzvm.zze, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzbvc().zzw((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzbvg().zzbwc().zze("Failed to unzip queued bundle", string, iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                object = zzarc.zzbd((byte[])byArray);
                zzvm.zze zze2 = new zzvm.zze();
                try {
                    zzvm.zze cfr_ignored_0 = (zzvm.zze)zze2.zzb((zzarc)object);
                }
                catch (IOException iOException) {
                    this.zzbvg().zzbwc().zze("Failed to merge queued bundle", string, iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzvm.zze, Long>)Pair.create((Object)((Object)zze2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzvm.zze, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    public void zzbk(long l) {
        this.zzyl();
        this.zzaax();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(l)};
        int n = sQLiteDatabase.delete("queue", "rowid=?", stringArray);
        if (n != 1) {
            this.zzbvg().zzbwc().log("Deleted fewer rows from queue than expected");
        }
    }

    @WorkerThread
    void zzbvl() {
        this.zzyl();
        this.zzaax();
        if (!this.zzbvr()) {
            return;
        }
        long l = this.zzbvh().apT.get();
        long l2 = this.zzaan().elapsedRealtime();
        if (Math.abs(l2 - l) > this.zzbvi().zzbuf()) {
            this.zzbvh().apT.set(l2);
            this.zzbvm();
        }
    }

    @WorkerThread
    void zzbvm() {
        this.zzyl();
        this.zzaax();
        if (!this.zzbvr()) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(this.zzaan().currentTimeMillis()), String.valueOf(this.zzbvi().zzbue())};
        int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
        if (n > 0) {
            this.zzbvg().zzbwj().zzj("Deleted stale rows. rowsDeleted", n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, zzvk.zza[] zzaArray) {
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        zzac.zzy((Object)zzaArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            this.zzmc(string);
            for (zzvk.zza zza2 : zzaArray) {
                this.zza(string, zza2);
            }
            ArrayList arrayList = new ArrayList();
            for (zzvk.zza zza3 : zzaArray) {
                arrayList.add(zza3.asA);
            }
            this.zzc(string, arrayList);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    void zzmc(String string) {
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=?", new String[]{string});
        sQLiteDatabase.delete("event_filters", "app_id=?", new String[]{string});
    }

    @WorkerThread
    void zzaa(String string, int n) {
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
        sQLiteDatabase.delete("event_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void zza(String string, zzvk.zza zza2) {
        void var7_13;
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        zzac.zzy((Object)((Object)zza2));
        zzac.zzy((Object)zza2.asC);
        zzac.zzy((Object)zza2.asB);
        if (zza2.asA == null) {
            this.zzbvg().zzbwe().log("Audience with no ID");
            return;
        }
        int n = zza2.asA;
        for (zzvk.zzb zzb2 : zza2.asC) {
            if (zzb2.asE != null) continue;
            this.zzbvg().zzbwe().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", string, zza2.asA);
            return;
        }
        for (zzark zzark2 : zza2.asB) {
            if (zzark2.asE != null) continue;
            this.zzbvg().zzbwe().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", string, zza2.asA);
            return;
        }
        boolean bl = true;
        zzark[] zzarkArray = zza2.asC;
        int n2 = zzarkArray.length;
        boolean bl2 = false;
        while (var7_13 < n2) {
            zzvk.zzb zzb2 = zzarkArray[var7_13];
            if (!this.zza(string, n, zzb2)) {
                bl = false;
                break;
            }
            ++var7_13;
        }
        if (bl) {
            void var7_15;
            zzarkArray = zza2.asB;
            n2 = zzarkArray.length;
            boolean bl3 = false;
            while (var7_15 < n2) {
                zzark zzark3 = zzarkArray[var7_15];
                if (!this.zza(string, n, (zzvk.zze)zzark3)) {
                    bl = false;
                    break;
                }
                ++var7_15;
            }
        }
        if (!bl) {
            this.zzaa(string, n);
        }
    }

    @WorkerThread
    private boolean zza(String string, int n, zzvk.zzb zzb2) {
        zzard zzard2;
        byte[] byArray;
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        zzac.zzy((Object)((Object)zzb2));
        if (TextUtils.isEmpty((CharSequence)zzb2.asF)) {
            this.zzbvg().zzbwe().zze("Event filter had no event name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zzb2.asE));
            return false;
        }
        try {
            int n2 = zzb2.db();
            byArray = new byte[n2];
            zzard2 = zzard.zzbe((byte[])byArray);
            zzb2.zza(zzard2);
            zzard2.cO();
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Configuration loss. Failed to serialize event filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.asE);
        contentValues.put("event_name", zzb2.asF);
        contentValues.put("data", byArray);
        try {
            zzard2 = this.getWritableDatabase();
            long l = zzard2.insertWithOnConflict("event_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzbvg().zzbwc().log("Failed to insert event filter (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing event filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private boolean zza(String string, int n, zzvk.zze zze2) {
        zzard zzard2;
        byte[] byArray;
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        zzac.zzy((Object)((Object)zze2));
        if (TextUtils.isEmpty((CharSequence)zze2.asU)) {
            this.zzbvg().zzbwe().zze("Property filter had no property name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zze2.asE));
            return false;
        }
        try {
            int n2 = zze2.db();
            byArray = new byte[n2];
            zzard2 = zzard.zzbe((byte[])byArray);
            zze2.zza(zzard2);
            zzard2.cO();
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Configuration loss. Failed to serialize property filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.asE);
        contentValues.put("property_name", zze2.asU);
        contentValues.put("data", byArray);
        try {
            zzard2 = this.getWritableDatabase();
            long l = zzard2.insertWithOnConflict("property_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzbvg().zzbwc().log("Failed to insert property filter (got -1)");
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing property filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzvk.zzb>> zzat(String string, String string2) {
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        zzac.zzhz((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzvk.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzarc zzarc2 = zzarc.zzbd((byte[])byArray);
                zzvk.zzb zzb2 = new zzvk.zzb();
                try {
                    zzvk.zzb cfr_ignored_0 = (zzvk.zzb)zzb2.zzb(zzarc2);
                }
                catch (IOException iOException) {
                    this.zzbvg().zzbwc().zze("Failed to merge filter", string, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzvk.zzb> arrayList = (ArrayList<zzvk.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzvk.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzvk.zze>> zzau(String string, String string2) {
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        zzac.zzhz((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzvk.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzarc zzarc2 = zzarc.zzbd((byte[])byArray);
                zzvk.zze zze2 = new zzvk.zze();
                try {
                    zzvk.zze cfr_ignored_0 = (zzvk.zze)zze2.zzb(zzarc2);
                }
                catch (IOException iOException) {
                    this.zzbvg().zzbwc().zze("Failed to merge filter", string, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzvk.zze> arrayList = (ArrayList<zzvk.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzvk.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        zzac.zzhz((String)string);
        this.zzaax();
        this.zzyl();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Database error querying filters", (Object)sQLiteException);
            return false;
        }
        int n = this.zzbvi().zzlt(string);
        if (l <= (long)n) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object == null || !(object instanceof Integer)) {
                    return false;
                }
                arrayList.add(Integer.toString((Integer)object));
            }
        }
        object = String.valueOf(TextUtils.join((CharSequence)",", arrayList));
        String string2 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        int n2 = sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string2).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string2).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n)});
        return n2 > 0;
    }

    void zza(String string, int n, zzvm.zzf zzf2) {
        zzard zzard2;
        byte[] byArray;
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        zzac.zzy((Object)((Object)zzf2));
        try {
            int n2 = zzf2.db();
            byArray = new byte[n2];
            zzard2 = zzard.zzbe((byte[])byArray);
            zzf2.zza(zzard2);
            zzard2.cO();
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Configuration loss. Failed to serialize filter results", iOException);
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("current_results", byArray);
        try {
            zzard2 = this.getWritableDatabase();
            long l = zzard2.insertWithOnConflict("audience_filter_values", null, contentValues, 5);
            if (l == -1L) {
                this.zzbvg().zzbwc().log("Failed to insert filter results (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing filter results", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, zzvm.zzf> zzmd(String string) {
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_4 = null;
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzarc zzarc2 = zzarc.zzbd((byte[])byArray);
                zzvm.zzf zzf2 = new zzvm.zzf();
                try {
                    zzvm.zzf cfr_ignored_0 = (zzvm.zzf)zzf2.zzb(zzarc2);
                }
                catch (IOException iOException) {
                    this.zzbvg().zzbwc().zzd("Failed to merge filter results. appId, audienceId, error", string, n, iOException);
                    continue;
                }
                arrayMap.put(n, zzf2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    void zzme(String string) {
        this.zzaax();
        this.zzyl();
        zzac.zzhz((String)string);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = 0;
            String[] stringArray = new String[]{string};
            n = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("apps", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("event_filters", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("property_filters", "app_id=?", stringArray);
            if ((n += sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray)) > 0) {
                this.zzbvg().zzbwj().zze("Deleted application data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zze("Error deleting application data. appId, error", string, (Object)sQLiteException);
        }
    }

    @WorkerThread
    void zza(ContentValues contentValues, String string, Object object) {
        zzac.zzhz((String)string);
        zzac.zzy((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
        } else if (object instanceof Long) {
            contentValues.put(string, (Long)object);
        } else if (object instanceof Double) {
            contentValues.put(string, (Double)object);
        } else {
            throw new IllegalArgumentException("Invalid value type");
        }
    }

    @WorkerThread
    @TargetApi(value=11)
    static int zza(Cursor cursor, int n) {
        int n2;
        if (Build.VERSION.SDK_INT >= 11) {
            return cursor.getType(n);
        }
        SQLiteCursor sQLiteCursor = (SQLiteCursor)cursor;
        CursorWindow cursorWindow = sQLiteCursor.getWindow();
        if (cursorWindow.isNull(n2 = cursor.getPosition(), n)) {
            return 0;
        }
        if (cursorWindow.isLong(n2, n)) {
            return 1;
        }
        if (cursorWindow.isFloat(n2, n)) {
            return 2;
        }
        if (cursorWindow.isString(n2, n)) {
            return 3;
        }
        if (cursorWindow.isBlob(n2, n)) {
            return 4;
        }
        return -1;
    }

    @WorkerThread
    Object zzb(Cursor cursor, int n) {
        int n2 = zze.zza(cursor, n);
        switch (n2) {
            case 0: {
                this.zzbvg().zzbwc().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzbvg().zzbwc().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzbvg().zzbwc().zzj("Loaded invalid unknown value type, ignoring it", n2);
        return null;
    }

    @WorkerThread
    public long zzbvn() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public long zzmf(String string) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaax();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            l = this.zza("select first_open_count from app2 where app_id=?", new String[]{string}, 0L);
            this.zzg(string, l + 1L);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    protected void zzg(String string, long l) {
        zzac.zzhz((String)string);
        this.zzyl();
        this.zzaax();
        if (l <= 0L) {
            this.zzbvg().zzbwc().log("Nonpositive first open count received, ignoring");
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("first_open_count", Long.valueOf(l));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l2 = sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5);
            if (l2 == -1L) {
                this.zzbvg().zzbwc().log("Failed to insert/replace first open count (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error inserting/replacing first open count", (Object)sQLiteException);
        }
    }

    @WorkerThread
    public long zzbvo() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public long zza(zzvm.zze zze2) throws IOException {
        byte[] byArray;
        this.zzyl();
        this.zzaax();
        zzac.zzy((Object)((Object)zze2));
        zzac.zzhz((String)zze2.zzck);
        try {
            int n = zze2.db();
            byArray = new byte[n];
            zzard zzard2 = zzard.zzbe((byte[])byArray);
            zze2.zza(zzard2);
            zzard2.cO();
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Data loss. Failed to serialize event metadata", iOException);
            throw iOException;
        }
        long l = this.zzbvc().zzy(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzck);
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing raw event metadata", (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public boolean zzbvp() {
        long l = this.zzb("select count(1) > 0 from raw_events", (String[])null);
        return l != 0L;
    }

    public boolean zzbvq() {
        long l = this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null);
        return l != 0L;
    }

    public void zzaf(List<Long> list) {
        zzac.zzy(list);
        this.zzyl();
        this.zzaax();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzbvg().zzbwc().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public void zzmg(String string) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string, string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Failed to remove unused event metadata", (Object)sQLiteException);
        }
    }

    public long zzmh(String string) {
        zzac.zzhz((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzbl(long l) {
        this.zzyl();
        this.zzaax();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzbvg().zzbwj().log("No expired configs for apps with pending events");
                Object var5_5 = null;
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string, long l, zzb zzb2) {
        zzac.zzy((Object)zzb2);
        this.zzyl();
        this.zzaax();
        try (Cursor cursor = null;){
            String string2;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if (TextUtils.isEmpty((CharSequence)string)) {
                cursor = sQLiteDatabase.rawQuery("select app_id, metadata_fingerprint from raw_events where app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", new String[]{String.valueOf(l)});
                if (!cursor.moveToFirst()) {
                    return;
                }
                string = cursor.getString(0);
                string2 = cursor.getString(1);
                cursor.close();
            } else {
                cursor = sQLiteDatabase.rawQuery("select metadata_fingerprint from raw_events where app_id = ? order by rowid limit 1;", new String[]{string});
                if (!cursor.moveToFirst()) {
                    return;
                }
                string2 = cursor.getString(0);
                cursor.close();
            }
            cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id=? and metadata_fingerprint=?", new String[]{string, string2}, null, null, "rowid", "2");
            if (!cursor.moveToFirst()) {
                this.zzbvg().zzbwc().log("Raw event metadata record is missing");
                return;
            }
            byte[] byArray = cursor.getBlob(0);
            zzarc zzarc2 = zzarc.zzbd((byte[])byArray);
            zzvm.zze zze2 = new zzvm.zze();
            try {
                zzvm.zze cfr_ignored_0 = (zzvm.zze)zze2.zzb(zzarc2);
            }
            catch (IOException iOException) {
                this.zzbvg().zzbwc().zze("Data loss. Failed to merge raw event metadata", string, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            if (cursor.moveToNext()) {
                this.zzbvg().zzbwe().log("Get multiple raw event metadata records, expected one");
            }
            cursor.close();
            zzb2.zzb(zze2);
            cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, "app_id=? and metadata_fingerprint=?", new String[]{string, string2}, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                this.zzbvg().zzbwe().log("Raw event data disappeared while in transaction");
                return;
            }
            do {
                long l2 = cursor.getLong(0);
                byArray = cursor.getBlob(3);
                zzarc2 = zzarc.zzbd((byte[])byArray);
                zzvm.zzb zzb3 = new zzvm.zzb();
                try {
                    zzvm.zzb cfr_ignored_1 = (zzvm.zzb)zzb3.zzb(zzarc2);
                }
                catch (IOException iOException) {
                    this.zzbvg().zzbwc().zze("Data loss. Failed to merge raw event", string, iOException);
                    continue;
                }
                zzb3.name = cursor.getString(1);
                zzb3.atp = cursor.getLong(2);
                if (zzb2.zza(l2, zzb3)) continue;
                return;
            } while (cursor.moveToNext());
        }
    }

    public void zza(zzh zzh2, long l, boolean bl) {
        Object object;
        zzvm.zzc zzc2;
        this.zzyl();
        this.zzaax();
        zzac.zzy((Object)zzh2);
        zzac.zzhz((String)zzh2.zzcpe);
        zzvm.zzb zzb2 = new zzvm.zzb();
        zzb2.atq = zzh2.aor;
        zzb2.ato = new zzvm.zzc[zzh2.aos.size()];
        int n = 0;
        for (String string : zzh2.aos) {
            zzc2 = new zzvm.zzc();
            zzb2.ato[n++] = zzc2;
            zzc2.name = string;
            Object object2 = zzh2.aos.get(string);
            this.zzbvc().zza(zzc2, object2);
        }
        try {
            int n2 = zzb2.db();
            object = new byte[n2];
            zzc2 = zzard.zzbe((byte[])object);
            zzb2.zza((zzard)zzc2);
            zzc2.cO();
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Data loss. Failed to serialize event params/data", iOException);
            return;
        }
        this.zzbvg().zzbwj().zze("Saving event, name, data size", zzh2.mName, ((Object)object).length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzh2.zzcpe);
        contentValues.put("name", zzh2.mName);
        contentValues.put("timestamp", Long.valueOf(zzh2.tr));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", (byte[])object);
        contentValues.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            zzc2 = this.getWritableDatabase();
            long l2 = zzc2.insert("raw_events", null, contentValues);
            if (l2 == -1L) {
                this.zzbvg().zzbwc().log("Failed to insert raw event (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbvg().zzbwc().zzj("Error storing raw event", (Object)sQLiteException);
        }
    }

    private boolean zzbvr() {
        return this.getContext().getDatabasePath(this.zzabs()).exists();
    }

    static {
        aoa.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        aoa.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        aoa.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        aoa.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        aoa.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        aoa.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        aoa.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        aoa.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        aoa.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        aoa.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        aoa.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        aoa.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        aoa.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        aoa.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        aoa.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        aoa.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
        aoa.put("daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;");
        aob = new ArrayMap(1);
        aob.put("realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;");
        aoc = new ArrayMap(1);
        aoc.put("has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;");
    }

    private class zzc
    extends SQLiteOpenHelper {
        zzc(Context context, String string) {
            super(context, string, null, 1);
        }

        @WorkerThread
        public SQLiteDatabase getWritableDatabase() {
            if (!zze.this.aoe.zzz(zze.this.zzbvi().zzbtz())) {
                throw new SQLiteException("Database open failed");
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zze.this.aoe.start();
                zze.this.zzbvg().zzbwc().log("Opening the database failed, dropping and recreating it");
                String string = zze.this.zzabs();
                if (!zze.this.getContext().getDatabasePath(string).delete()) {
                    zze.this.zzbvg().zzbwc().zzj("Failed to delete corrupted db file", string);
                }
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zze.this.aoe.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zze.this.zzbvg().zzbwc().zzj("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
            try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
                Collections.addAll(hashSet, cursor.getColumnNames());
            }
            return hashSet;
        }

        @WorkerThread
        private void zza(SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
            Set<String> set = this.zzb(sQLiteDatabase, string);
            for (String string3 : string2.split(",")) {
                if (set.remove(string3)) continue;
                throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    if (set.remove(entry.getKey())) continue;
                    sQLiteDatabase.execSQL((String)entry.getValue());
                }
            }
            if (!set.isEmpty()) {
                zze.this.zzbvg().zzbwe().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
            }
        }

        @WorkerThread
        private void zza(SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
            if (!this.zza(sQLiteDatabase, string)) {
                sQLiteDatabase.execSQL(string2);
            }
            try {
                this.zza(sQLiteDatabase, string, string3, map);
            }
            catch (SQLiteException sQLiteException) {
                zze.this.zzbvg().zzbwc().zzj("Failed to verify columns on table that was just created", string);
                throw sQLiteException;
            }
        }

        @WorkerThread
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            this.zza(sQLiteDatabase, "events", "CREATE TABLE IF NOT EXISTS events ( app_id TEXT NOT NULL, name TEXT NOT NULL, lifetime_count INTEGER NOT NULL, current_bundle_count INTEGER NOT NULL, last_fire_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,lifetime_count,current_bundle_count,last_fire_timestamp", null);
            this.zza(sQLiteDatabase, "user_attributes", "CREATE TABLE IF NOT EXISTS user_attributes ( app_id TEXT NOT NULL, name TEXT NOT NULL, set_timestamp INTEGER NOT NULL, value BLOB NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,set_timestamp,value", null);
            this.zza(sQLiteDatabase, "apps", "CREATE TABLE IF NOT EXISTS apps ( app_id TEXT NOT NULL, app_instance_id TEXT, gmp_app_id TEXT, resettable_device_id_hash TEXT, last_bundle_index INTEGER NOT NULL, last_bundle_end_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id)) ;", "app_id,app_instance_id,gmp_app_id,resettable_device_id_hash,last_bundle_index,last_bundle_end_timestamp", aoa);
            this.zza(sQLiteDatabase, "queue", "CREATE TABLE IF NOT EXISTS queue ( app_id TEXT NOT NULL, bundle_end_timestamp INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,bundle_end_timestamp,data", aoc);
            this.zza(sQLiteDatabase, "raw_events_metadata", "CREATE TABLE IF NOT EXISTS raw_events_metadata ( app_id TEXT NOT NULL, metadata_fingerprint INTEGER NOT NULL, metadata BLOB NOT NULL, PRIMARY KEY (app_id, metadata_fingerprint));", "app_id,metadata_fingerprint,metadata", null);
            this.zza(sQLiteDatabase, "raw_events", "CREATE TABLE IF NOT EXISTS raw_events ( app_id TEXT NOT NULL, name TEXT NOT NULL, timestamp INTEGER NOT NULL, metadata_fingerprint INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,name,timestamp,metadata_fingerprint,data", aob);
            this.zza(sQLiteDatabase, "event_filters", "CREATE TABLE IF NOT EXISTS event_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, event_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, event_name, audience_id, filter_id));", "app_id,audience_id,filter_id,event_name,data", null);
            this.zza(sQLiteDatabase, "property_filters", "CREATE TABLE IF NOT EXISTS property_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, property_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, property_name, audience_id, filter_id));", "app_id,audience_id,filter_id,property_name,data", null);
            this.zza(sQLiteDatabase, "audience_filter_values", "CREATE TABLE IF NOT EXISTS audience_filter_values ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, current_results BLOB, PRIMARY KEY (app_id, audience_id));", "app_id,audience_id,current_results", null);
            this.zza(sQLiteDatabase, "app2", "CREATE TABLE IF NOT EXISTS app2 ( app_id TEXT NOT NULL, first_open_count INTEGER NOT NULL, PRIMARY KEY (app_id));", "app_id,first_open_count", null);
        }

        @WorkerThread
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT >= 9) {
                File file = new File(sQLiteDatabase.getPath());
                if (!file.setReadable(false, false)) {
                    zze.this.zzbvg().zzbwe().log("Failed to turn off database read permission");
                }
                if (!file.setWritable(false, false)) {
                    zze.this.zzbvg().zzbwe().log("Failed to turn off database write permission");
                }
                if (!file.setReadable(true, true)) {
                    zze.this.zzbvg().zzbwe().log("Failed to turn on database read permission for owner");
                }
                if (!file.setWritable(true, true)) {
                    zze.this.zzbvg().zzbwe().log("Failed to turn on database write permission for owner");
                }
            }
        }

        @WorkerThread
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }

    static interface zzb {
        public void zzb(zzvm.zze var1);

        public boolean zza(long var1, zzvm.zzb var3);
    }

    public static class zza {
        long aof;
        long aog;
        long aoh;
        long aoi;
        long aoj;
    }
}

