/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class zzd
extends zzz {
    static final String anZ = String.valueOf(zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE / 1000).replaceAll("(\\d+)(\\d)(\\d\\d)", "$1.$2.$3");
    private Boolean bU;

    zzd(zzx zzx2) {
        super(zzx2);
    }

    String zzbtl() {
        return zzl.aoE.get();
    }

    public int zzbtm() {
        return 25;
    }

    public int zzbtn() {
        return 32;
    }

    public int zzbto() {
        return 24;
    }

    int zzbtp() {
        return 24;
    }

    int zzbtq() {
        return 36;
    }

    int zzbtr() {
        return 256;
    }

    public int zzbts() {
        return 36;
    }

    public int zzbtt() {
        return 2048;
    }

    int zzbtu() {
        return 500;
    }

    public long zzbtv() {
        return zzl.aoO.get().intValue();
    }

    public long zzbtw() {
        return zzl.aoQ.get().intValue();
    }

    public int zzlo(@Size(min=1L) String string) {
        int n = this.zzb(string, zzl.aoP);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzlp(@Size(min=1L) String string) {
        return this.zzb(string, zzl.aoR);
    }

    public int zzlq(@Size(min=1L) String string) {
        return this.zzb(string, zzl.aoS);
    }

    int zzbtx() {
        return 25;
    }

    int zzbty() {
        return 50;
    }

    long zzbtz() {
        return 3600000L;
    }

    long zzbua() {
        return 60000L;
    }

    long zzbub() {
        return 61000L;
    }

    long zzlr(String string) {
        return this.zza(string, zzl.aoF);
    }

    int zzls(String string) {
        return this.zzb(string, zzl.apg);
    }

    int zzlt(String string) {
        int n = this.zzb(string, zzl.aph);
        n = Math.min(2000, n);
        n = Math.max(0, n);
        return n;
    }

    long zzado() {
        return zzl.api.get();
    }

    public String zzadt() {
        return "google_app_measurement.db";
    }

    public String zzadu() {
        return "google_app_measurement2.db";
    }

    public long zzbsy() {
        return 9683L;
    }

    public boolean zzact() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzacu() {
        if (this.bU == null) {
            zzd zzd2 = this;
            synchronized (zzd2) {
                if (this.bU == null) {
                    ApplicationInfo applicationInfo = this.getContext().getApplicationInfo();
                    String string = zzt.zzaxy();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.bU = string2 != null && string2.equals(string);
                    }
                    if (this.bU == null) {
                        this.bU = Boolean.TRUE;
                        this.zzbvg().zzbwc().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.bU;
    }

    public long zza(String string, zzl.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzbvd().zzaw(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.valueOf(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    public int zzb(String string, zzl.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzbvd().zzaw(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.valueOf(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @Nullable
    Boolean zzlu(@Size(min=1L) String string) {
        zzac.zzhz((String)string);
        try {
            PackageManager packageManager = this.getContext().getPackageManager();
            if (packageManager == null) {
                this.zzbvg().zzbwc().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(this.getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                this.zzbvg().zzbwc().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                this.zzbvg().zzbwc().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzbvg().zzbwc().zzj("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public boolean zzbuc() {
        if (this.zzact()) {
            return false;
        }
        Boolean bl = this.zzlu("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public Boolean zzbud() {
        if (this.zzact()) {
            return null;
        }
        return this.zzlu("firebase_analytics_collection_enabled");
    }

    public boolean zzasm() {
        return zzqw.zzasm();
    }

    public long zzbue() {
        return zzl.apf.get();
    }

    public long zzbuf() {
        return zzl.apb.get();
    }

    public long zzbug() {
        return 1000L;
    }

    public long zzadz() {
        return Math.max(0L, zzl.aoG.get());
    }

    public int zzlv(String string) {
        return this.zzb(string, zzl.aoK);
    }

    public int zzlw(String string) {
        return Math.max(0, this.zzb(string, zzl.aoL));
    }

    public int zzlx(String string) {
        int n = this.zzb(string, zzl.aoT);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzbuh() {
        return Math.max(0, zzl.aoM.get());
    }

    public int zzbui() {
        return Math.max(1, zzl.aoN.get());
    }

    public String zzbuj() {
        return zzl.aoU.get();
    }

    public String zzap(String string, String string2) {
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string);
        builder.scheme(zzl.aoI.get()).encodedAuthority(zzl.aoJ.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string2).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(this.zzbsy()));
        return builder.build().toString();
    }

    public long zzbuk() {
        return zzl.aoH.get();
    }

    public long zzbul() {
        return Math.max(0L, zzl.aoV.get());
    }

    public long zzbum() {
        return Math.max(0L, zzl.aoX.get());
    }

    public long zzbun() {
        return Math.max(0L, zzl.aoY.get());
    }

    public long zzbuo() {
        return Math.max(0L, zzl.aoZ.get());
    }

    public long zzbup() {
        return Math.max(0L, zzl.apa.get());
    }

    public long zzbuq() {
        return zzl.aoW.get();
    }

    public long zzbur() {
        return Math.max(0L, zzl.apc.get());
    }

    public long zzbus() {
        return Math.max(0L, zzl.apd.get());
    }

    public int zzbut() {
        return Math.min(20, Math.max(0, zzl.ape.get()));
    }

    public String zzbuu() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class, String.class);
            return (String)method.invoke(null, "firebase.analytics.debug-mode", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzbvg().zzbwc().zzj("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzbvg().zzbwc().zzj("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzbvg().zzbwc().zzj("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzbvg().zzbwc().zzj("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }
}

