/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.imageio.ImageIO;

public final class ImageConverter {
    private static final String FORMAT = "png";
    private static final int WHITE = -1;
    private static final int BLACK = -16777216;
    private static final int RED = -65536;
    private static boolean rowSampling = false;

    private ImageConverter() {
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            if ("-row".equals(arg)) {
                rowSampling = true;
                continue;
            }
            if ("-2d".equals(arg)) {
                rowSampling = false;
                continue;
            }
            if (!arg.startsWith("-")) continue;
            System.err.println("Ignoring unrecognized option: " + arg);
        }
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            File inputFile = new File(arg);
            if (inputFile.exists()) {
                if (inputFile.isDirectory()) {
                    for (File input : inputFile.listFiles()) {
                        String filename = input.getName().toLowerCase();
                        if (filename.startsWith(".") || filename.endsWith(".txt") || filename.contains(".mono.png") || filename.contains(".row.png") || filename.contains(".2d.png")) continue;
                        ImageConverter.convertImage(input.toURI());
                    }
                    continue;
                }
                ImageConverter.convertImage(inputFile.toURI());
                continue;
            }
            ImageConverter.convertImage(new URI(arg));
        }
    }

    private static void convertImage(URI uri) throws IOException {
        BufferedImage image = ImageIO.read(uri.toURL());
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        BitArray array = new BitArray(width);
        if (rowSampling) {
            for (int y = 0; y < height; ++y) {
                try {
                    array = bitmap.getBlackRow(y, array);
                }
                catch (NotFoundException nfe) {
                    for (int x = 0; x < width; ++x) {
                        result.setRGB(x, y, -65536);
                    }
                    continue;
                }
                for (int x = 0; x < width; ++x) {
                    result.setRGB(x, y, array.get(x) ? -16777216 : -1);
                }
            }
        } else {
            try {
                BitMatrix matrix = bitmap.getBlackMatrix();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        result.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
                    }
                }
            }
            catch (NotFoundException nfe) {
                // empty catch block
            }
        }
        File output = ImageConverter.getOutput(uri);
        System.out.printf("Writing output to %s\n", output);
        ImageIO.write((RenderedImage)result, FORMAT, output);
    }

    private static File getFileOfUri(URI uri) {
        String basename;
        String parent;
        String name = uri.getPath();
        int slashPos = name.lastIndexOf(47);
        if (slashPos != -1 && slashPos != name.length() - 1) {
            parent = name.substring(0, slashPos);
            basename = name.substring(slashPos + 1);
        } else {
            parent = ".";
            basename = name;
        }
        File parentFile = new File(parent);
        if (!parentFile.exists()) {
            return null;
        }
        File baseFile = new File(parent, basename);
        if (!baseFile.exists()) {
            return null;
        }
        return baseFile;
    }

    private static File getOutput(URI uri) {
        File result = ImageConverter.getFileOfUri(uri);
        if (result == null) {
            result = new File("ConvertedImage.png");
        } else {
            String name = result.getPath();
            int dotpos = name.lastIndexOf(46);
            if (dotpos != -1) {
                name = name.substring(0, dotpos);
            }
            String suffix = rowSampling ? "row" : "2d";
            result = new File(name + '.' + suffix + '.' + FORMAT);
        }
        return result;
    }
}

