/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLineRunner {
    private CommandLineRunner() {
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            CommandLineRunner.printUsage();
            return;
        }
        boolean tryHarder = false;
        boolean pureBarcode = false;
        boolean productsOnly = false;
        boolean dumpResults = false;
        boolean dumpBlackPoint = false;
        for (String arg : args) {
            if ("--try_harder".equals(arg)) {
                tryHarder = true;
                continue;
            }
            if ("--pure_barcode".equals(arg)) {
                pureBarcode = true;
                continue;
            }
            if ("--products_only".equals(arg)) {
                productsOnly = true;
                continue;
            }
            if ("--dump_results".equals(arg)) {
                dumpResults = true;
                continue;
            }
            if ("--dump_black_point".equals(arg)) {
                dumpBlackPoint = true;
                continue;
            }
            if (!arg.startsWith("-")) continue;
            System.err.println("Unknown command line option " + arg);
            CommandLineRunner.printUsage();
            return;
        }
        Hashtable<DecodeHintType, Object> hints = CommandLineRunner.buildHints(tryHarder, pureBarcode, productsOnly);
        for (String arg : args) {
            if (arg.startsWith("--")) continue;
            CommandLineRunner.decodeOneArgument(arg, hints, dumpResults, dumpBlackPoint);
        }
    }

    private static Hashtable<DecodeHintType, Object> buildHints(boolean tryHarder, boolean pureBarcode, boolean productsOnly) {
        Hashtable<DecodeHintType, Object> hints = new Hashtable<DecodeHintType, Object>(3);
        Vector<BarcodeFormat> vector = new Vector<BarcodeFormat>(8);
        vector.addElement(BarcodeFormat.UPC_A);
        vector.addElement(BarcodeFormat.UPC_E);
        vector.addElement(BarcodeFormat.EAN_13);
        vector.addElement(BarcodeFormat.EAN_8);
        if (!productsOnly) {
            vector.addElement(BarcodeFormat.CODE_39);
            vector.addElement(BarcodeFormat.CODE_128);
            vector.addElement(BarcodeFormat.ITF);
            vector.addElement(BarcodeFormat.QR_CODE);
            vector.addElement(BarcodeFormat.DATAMATRIX);
            vector.addElement(BarcodeFormat.PDF417);
        }
        hints.put(DecodeHintType.POSSIBLE_FORMATS, vector);
        if (tryHarder) {
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (pureBarcode) {
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return hints;
    }

    private static void printUsage() {
        System.err.println("Decode barcode images using the ZXing library\n");
        System.err.println("usage: CommandLineRunner { file | dir | url } [ options ]");
        System.err.println("  --try_harder: Use the TRY_HARDER hint, default is normal (mobile) mode");
        System.err.println("  --products_only: Only decode the UPC and EAN families of barcodes");
        System.err.println("  --dump_results: Write the decoded contents to input.txt");
        System.err.println("  --dump_black_point: Compare black point algorithms as input.mono.png");
    }

    private static void decodeOneArgument(String argument, Hashtable<DecodeHintType, Object> hints, boolean dumpResults, boolean dumpBlackPoint) throws IOException, URISyntaxException {
        File inputFile = new File(argument);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                int successful = 0;
                int total = 0;
                for (File input : inputFile.listFiles()) {
                    String filename = input.getName().toLowerCase();
                    if (filename.startsWith(".") || filename.endsWith(".txt") || filename.contains(".mono.png")) continue;
                    Result result = CommandLineRunner.decode(input.toURI(), hints, dumpBlackPoint);
                    if (result != null) {
                        ++successful;
                        if (dumpResults) {
                            CommandLineRunner.dumpResult(input, result);
                        }
                    }
                    ++total;
                }
                System.out.println("\nDecoded " + successful + " files out of " + total + " successfully (" + successful * 100 / total + "%)\n");
            } else {
                Result result = CommandLineRunner.decode(inputFile.toURI(), hints, dumpBlackPoint);
                if (dumpResults) {
                    CommandLineRunner.dumpResult(inputFile, result);
                }
            }
        } else {
            CommandLineRunner.decode(new URI(argument), hints, dumpBlackPoint);
        }
    }

    private static void dumpResult(File input, Result result) throws IOException {
        String name = input.getAbsolutePath();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        File dump = new File(name + ".txt");
        CommandLineRunner.writeStringToFile(result.getText(), dump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStringToFile(String value, File file) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
        try {
            out.write(value);
        }
        finally {
            ((Writer)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result decode(URI uri, Hashtable<DecodeHintType, Object> hints, boolean dumpBlackPoint) throws IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(uri.toURL());
        }
        catch (IllegalArgumentException iae) {
            throw new FileNotFoundException("Resource not found: " + uri);
        }
        if (image == null) {
            System.err.println(uri.toString() + ": Could not load image");
            return null;
        }
        try {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            if (dumpBlackPoint) {
                CommandLineRunner.dumpBlackPoint(uri, image, bitmap);
            }
            Result result = new MultiFormatReader().decode(bitmap, hints);
            ParsedResult parsedResult = ResultParser.parseResult((Result)result);
            System.out.println(uri.toString() + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
            Result result2 = result;
            return result2;
        }
        catch (NotFoundException nfe) {
            System.out.println(uri.toString() + ": No barcode found");
            Result result = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpBlackPoint(URI uri, BufferedImage image, BinaryBitmap bitmap) {
        int pos;
        int x;
        int offset;
        int y;
        String inputName = uri.getPath();
        if (inputName.contains(".mono.png")) {
            return;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int stride = width * 3;
        int[] pixels = new int[stride * height];
        int[] argb = new int[width];
        for (int y2 = 0; y2 < height; ++y2) {
            image.getRGB(0, y2, width, 1, argb, 0, width);
            System.arraycopy(argb, 0, pixels, y2 * stride, width);
        }
        BitArray row = new BitArray(width);
        for (y = 0; y < height; ++y) {
            try {
                row = bitmap.getBlackRow(y, row);
            }
            catch (NotFoundException nfe) {
                offset = y * stride + width;
                for (x = 0; x < width; ++x) {
                    pixels[offset + x] = -65536;
                }
                continue;
            }
            int offset2 = y * stride + width;
            for (int x2 = 0; x2 < width; ++x2) {
                pixels[offset2 + x2] = row.get(x2) ? -16777216 : -1;
            }
        }
        try {
            for (y = 0; y < height; ++y) {
                BitMatrix matrix = bitmap.getBlackMatrix();
                offset = y * stride + width * 2;
                for (x = 0; x < width; ++x) {
                    pixels[offset + x] = matrix.get(x, y) ? -16777216 : -1;
                }
            }
        }
        catch (NotFoundException nfe) {
            // empty catch block
        }
        BufferedImage result = new BufferedImage(stride, height, 2);
        result.setRGB(0, 0, stride, height, pixels, 0, stride);
        String resultName = inputName;
        if ("http".equals(uri.getScheme()) && (pos = resultName.lastIndexOf(47)) > 0) {
            resultName = '.' + resultName.substring(pos);
        }
        if ((pos = resultName.lastIndexOf(46)) > 0) {
            resultName = resultName.substring(0, pos);
        }
        resultName = resultName + ".mono.png";
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(resultName);
            ImageIO.write((RenderedImage)result, "png", outStream);
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not create " + resultName);
        }
        catch (IOException e) {
            System.err.println("Could not write to " + resultName);
        }
        finally {
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

