/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

final class DecodedBitStreamParser {
    private static final char[] ALPHANUMERIC_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
    private static final String SHIFT_JIS = "SJIS";
    private static final String EUC_JP = "EUC_JP";
    private static final boolean ASSUME_SHIFT_JIS;
    private static final String UTF8 = "UTF8";
    private static final String ISO88591 = "ISO8859_1";

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] bytes, Version version, ErrorCorrectionLevel ecLevel, Hashtable hints) throws FormatException {
        Mode mode;
        BitSource bits = new BitSource(bytes);
        StringBuffer result = new StringBuffer(50);
        CharacterSetECI currentCharacterSetECI = null;
        boolean fc1InEffect = false;
        Vector byteSegments = new Vector(1);
        do {
            if (bits.available() < 4) {
                mode = Mode.TERMINATOR;
            } else {
                try {
                    mode = Mode.forBits(bits.readBits(4));
                }
                catch (IllegalArgumentException iae) {
                    throw FormatException.getFormatInstance();
                }
            }
            if (mode.equals(Mode.TERMINATOR)) continue;
            if (mode.equals(Mode.FNC1_FIRST_POSITION) || mode.equals(Mode.FNC1_SECOND_POSITION)) {
                fc1InEffect = true;
                continue;
            }
            if (mode.equals(Mode.STRUCTURED_APPEND)) {
                bits.readBits(16);
                continue;
            }
            if (mode.equals(Mode.ECI)) {
                int value = DecodedBitStreamParser.parseECIValue(bits);
                currentCharacterSetECI = CharacterSetECI.getCharacterSetECIByValue(value);
                if (currentCharacterSetECI != null) continue;
                throw FormatException.getFormatInstance();
            }
            int count = bits.readBits(mode.getCharacterCountBits(version));
            if (mode.equals(Mode.NUMERIC)) {
                DecodedBitStreamParser.decodeNumericSegment(bits, result, count);
                continue;
            }
            if (mode.equals(Mode.ALPHANUMERIC)) {
                DecodedBitStreamParser.decodeAlphanumericSegment(bits, result, count, fc1InEffect);
                continue;
            }
            if (mode.equals(Mode.BYTE)) {
                DecodedBitStreamParser.decodeByteSegment(bits, result, count, currentCharacterSetECI, byteSegments, hints);
                continue;
            }
            if (mode.equals(Mode.KANJI)) {
                DecodedBitStreamParser.decodeKanjiSegment(bits, result, count);
                continue;
            }
            throw FormatException.getFormatInstance();
        } while (!mode.equals(Mode.TERMINATOR));
        return new DecoderResult(bytes, result.toString(), byteSegments.isEmpty() ? null : byteSegments, ecLevel);
    }

    private static void decodeKanjiSegment(BitSource bits, StringBuffer result, int count) throws FormatException {
        byte[] buffer = new byte[2 * count];
        int offset = 0;
        while (count > 0) {
            int twoBytes = bits.readBits(13);
            int assembledTwoBytes = twoBytes / 192 << 8 | twoBytes % 192;
            assembledTwoBytes = assembledTwoBytes < 7936 ? (assembledTwoBytes += 33088) : (assembledTwoBytes += 49472);
            buffer[offset] = (byte)(assembledTwoBytes >> 8);
            buffer[offset + 1] = (byte)assembledTwoBytes;
            offset += 2;
            --count;
        }
        try {
            result.append(new String(buffer, SHIFT_JIS));
        }
        catch (UnsupportedEncodingException uee) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void decodeByteSegment(BitSource bits, StringBuffer result, int count, CharacterSetECI currentCharacterSetECI, Vector byteSegments, Hashtable hints) throws FormatException {
        byte[] readBytes = new byte[count];
        if (count << 3 > bits.available()) {
            throw FormatException.getFormatInstance();
        }
        for (int i = 0; i < count; ++i) {
            readBytes[i] = (byte)bits.readBits(8);
        }
        String encoding = currentCharacterSetECI == null ? DecodedBitStreamParser.guessEncoding(readBytes, hints) : currentCharacterSetECI.getEncodingName();
        try {
            result.append(new String(readBytes, encoding));
        }
        catch (UnsupportedEncodingException uce) {
            throw FormatException.getFormatInstance();
        }
        byteSegments.addElement(readBytes);
    }

    private static void decodeAlphanumericSegment(BitSource bits, StringBuffer result, int count, boolean fc1InEffect) {
        int start = result.length();
        while (count > 1) {
            int nextTwoCharsBits = bits.readBits(11);
            result.append(ALPHANUMERIC_CHARS[nextTwoCharsBits / 45]);
            result.append(ALPHANUMERIC_CHARS[nextTwoCharsBits % 45]);
            count -= 2;
        }
        if (count == 1) {
            result.append(ALPHANUMERIC_CHARS[bits.readBits(6)]);
        }
        if (fc1InEffect) {
            for (int i = start; i < result.length(); ++i) {
                if (result.charAt(i) != '%') continue;
                if (i < result.length() - 1 && result.charAt(i + 1) == '%') {
                    result.deleteCharAt(i + 1);
                    continue;
                }
                result.setCharAt(i, '\u001d');
            }
        }
    }

    private static void decodeNumericSegment(BitSource bits, StringBuffer result, int count) throws FormatException {
        while (count >= 3) {
            int threeDigitsBits = bits.readBits(10);
            if (threeDigitsBits >= 1000) {
                throw FormatException.getFormatInstance();
            }
            result.append(ALPHANUMERIC_CHARS[threeDigitsBits / 100]);
            result.append(ALPHANUMERIC_CHARS[threeDigitsBits / 10 % 10]);
            result.append(ALPHANUMERIC_CHARS[threeDigitsBits % 10]);
            count -= 3;
        }
        if (count == 2) {
            int twoDigitsBits = bits.readBits(7);
            if (twoDigitsBits >= 100) {
                throw FormatException.getFormatInstance();
            }
            result.append(ALPHANUMERIC_CHARS[twoDigitsBits / 10]);
            result.append(ALPHANUMERIC_CHARS[twoDigitsBits % 10]);
        } else if (count == 1) {
            int digitBits = bits.readBits(4);
            if (digitBits >= 10) {
                throw FormatException.getFormatInstance();
            }
            result.append(ALPHANUMERIC_CHARS[digitBits]);
        }
    }

    private static String guessEncoding(byte[] bytes, Hashtable hints) {
        String characterSet;
        if (hints != null && (characterSet = (String)hints.get(DecodeHintType.CHARACTER_SET)) != null) {
            return characterSet;
        }
        if (ASSUME_SHIFT_JIS) {
            return SHIFT_JIS;
        }
        if (bytes.length > 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return UTF8;
        }
        int length = bytes.length;
        boolean canBeISO88591 = true;
        boolean canBeShiftJIS = true;
        int maybeDoubleByteCount = 0;
        int maybeSingleByteKatakanaCount = 0;
        boolean sawLatin1Supplement = false;
        boolean lastWasPossibleDoubleByteStart = false;
        for (int i = 0; i < length && (canBeISO88591 || canBeShiftJIS); ++i) {
            int nextValue;
            int value = bytes[i] & 0xFF;
            if ((value == 194 || value == 195) && i < length - 1 && (nextValue = bytes[i + 1] & 0xFF) <= 191 && (value == 194 && nextValue >= 160 || value == 195 && nextValue >= 128)) {
                sawLatin1Supplement = true;
            }
            if (value >= 127 && value <= 159) {
                canBeISO88591 = false;
            }
            if (value >= 161 && value <= 223 && !lastWasPossibleDoubleByteStart) {
                ++maybeSingleByteKatakanaCount;
            }
            if (!lastWasPossibleDoubleByteStart && (value >= 240 && value <= 255 || value == 128 || value == 160)) {
                canBeShiftJIS = false;
            }
            if (value >= 129 && value <= 159 || value >= 224 && value <= 239) {
                if (lastWasPossibleDoubleByteStart) {
                    lastWasPossibleDoubleByteStart = false;
                    continue;
                }
                lastWasPossibleDoubleByteStart = true;
                if (i >= bytes.length - 1) {
                    canBeShiftJIS = false;
                    continue;
                }
                nextValue = bytes[i + 1] & 0xFF;
                if (nextValue < 64 || nextValue > 252) {
                    canBeShiftJIS = false;
                    continue;
                }
                ++maybeDoubleByteCount;
                continue;
            }
            lastWasPossibleDoubleByteStart = false;
        }
        if (canBeShiftJIS && (maybeDoubleByteCount >= 3 || 20 * maybeSingleByteKatakanaCount > length)) {
            return SHIFT_JIS;
        }
        if (!sawLatin1Supplement && canBeISO88591) {
            return ISO88591;
        }
        return UTF8;
    }

    private static int parseECIValue(BitSource bits) {
        int firstByte = bits.readBits(8);
        if ((firstByte & 0x80) == 0) {
            return firstByte & 0x7F;
        }
        if ((firstByte & 0xC0) == 128) {
            int secondByte = bits.readBits(8);
            return (firstByte & 0x3F) << 8 | secondByte;
        }
        if ((firstByte & 0xE0) == 192) {
            int secondThirdBytes = bits.readBits(16);
            return (firstByte & 0x1F) << 16 | secondThirdBytes;
        }
        throw new IllegalArgumentException("Bad ECI bits starting with byte " + firstByte);
    }

    static {
        String platformDefault = System.getProperty("file.encoding");
        ASSUME_SHIFT_JIS = SHIFT_JIS.equalsIgnoreCase(platformDefault) || EUC_JP.equalsIgnoreCase(platformDefault);
    }
}

