/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.pdf417.decoder.Decoder;
import com.google.zxing.pdf417.detector.Detector;
import java.util.Hashtable;

public final class PDF417Reader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return this.decode(image, null);
    }

    public Result decode(BinaryBitmap image, Hashtable hints) throws NotFoundException, FormatException {
        ResultPoint[] points;
        DecoderResult decoderResult;
        if (hints != null && hints.containsKey(DecodeHintType.PURE_BARCODE)) {
            BitMatrix bits = PDF417Reader.extractPureBits(image);
            decoderResult = this.decoder.decode(bits);
            points = NO_POINTS;
        } else {
            DetectorResult detectorResult = new Detector(image).detect();
            decoderResult = this.decoder.decode(detectorResult.getBits());
            points = detectorResult.getPoints();
        }
        return new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.PDF417);
    }

    public void reset() {
    }

    private static BitMatrix extractPureBits(BinaryBitmap image) throws NotFoundException {
        int dimension;
        int sampleDimension;
        int rowEndOfSymbol;
        int moduleEnd;
        int borderWidth;
        BitMatrix matrix = image.getBlackMatrix();
        int height = matrix.getHeight();
        int width = matrix.getWidth();
        int minDimension = Math.min(height, width);
        for (borderWidth = 0; borderWidth < minDimension && !matrix.get(borderWidth, borderWidth); ++borderWidth) {
        }
        if (borderWidth == minDimension) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (moduleEnd = borderWidth; moduleEnd < minDimension && matrix.get(moduleEnd, moduleEnd); ++moduleEnd) {
        }
        if (moduleEnd == minDimension) {
            throw NotFoundException.getNotFoundInstance();
        }
        int moduleSize = moduleEnd - borderWidth;
        for (rowEndOfSymbol = width - 1; rowEndOfSymbol >= 0 && !matrix.get(rowEndOfSymbol, borderWidth); --rowEndOfSymbol) {
        }
        if (rowEndOfSymbol < 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((++rowEndOfSymbol - borderWidth) % moduleSize != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((sampleDimension = (borderWidth += moduleSize >> 1) + ((dimension = (rowEndOfSymbol - borderWidth) / moduleSize) - 1) * moduleSize) >= width || sampleDimension >= height) {
            throw NotFoundException.getNotFoundInstance();
        }
        BitMatrix bits = new BitMatrix(dimension);
        for (int y = 0; y < dimension; ++y) {
            int iOffset = borderWidth + y * moduleSize;
            for (int x = 0; x < dimension; ++x) {
                if (!matrix.get(borderWidth + x * moduleSize, iOffset)) continue;
                bits.set(x, y);
            }
        }
        return bits;
    }
}

