/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.ByteMatrix;
import com.google.zxing.oned.UPCEANReader;
import java.util.Hashtable;

public abstract class UPCEANWriter
implements Writer {
    public ByteMatrix encode(String contents, BarcodeFormat format, int width, int height) throws WriterException {
        return this.encode(contents, format, width, height, null);
    }

    public ByteMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        if (contents == null || contents.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + width + 'x' + height);
        }
        byte[] code = this.encode(contents);
        return UPCEANWriter.renderResult(code, width, height);
    }

    private static ByteMatrix renderResult(byte[] code, int width, int height) {
        int x;
        int inputWidth = code.length;
        int fullWidth = inputWidth + (UPCEANReader.START_END_PATTERN.length << 1);
        int outputWidth = Math.max(width, fullWidth);
        int outputHeight = Math.max(1, height);
        int multiple = outputWidth / fullWidth;
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        ByteMatrix output = new ByteMatrix(outputWidth, outputHeight);
        byte[][] outputArray = output.getArray();
        byte[] row = new byte[outputWidth];
        for (int x2 = 0; x2 < leftPadding; ++x2) {
            row[x2] = -1;
        }
        int offset = leftPadding;
        for (x = 0; x < inputWidth; ++x) {
            int value = code[x] == 1 ? 0 : -1;
            for (int z = 0; z < multiple; ++z) {
                row[offset + z] = value;
            }
            offset += multiple;
        }
        for (x = offset = leftPadding + inputWidth * multiple; x < outputWidth; ++x) {
            row[x] = -1;
        }
        for (int z = 0; z < outputHeight; ++z) {
            System.arraycopy(row, 0, outputArray[z], 0, outputWidth);
        }
        return output;
    }

    protected static int appendPattern(byte[] target, int pos, int[] pattern, int startColor) {
        if (startColor != 0 && startColor != 1) {
            throw new IllegalArgumentException("startColor must be either 0 or 1, but got: " + startColor);
        }
        byte color = (byte)startColor;
        int numAdded = 0;
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i]; ++j) {
                target[pos] = color;
                ++pos;
                ++numAdded;
            }
            color = (byte)(color ^ 1);
        }
        return numAdded;
    }

    public abstract byte[] encode(String var1);
}

