/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int MINIMUM_DIMENSION = 40;
    private BitMatrix matrix = null;

    public HybridBinarizer(LuminanceSource source) {
        super(source);
    }

    public BitMatrix getBlackMatrix() throws NotFoundException {
        this.binarizeEntireImage();
        return this.matrix;
    }

    public Binarizer createBinarizer(LuminanceSource source) {
        return new HybridBinarizer(source);
    }

    private void binarizeEntireImage() throws NotFoundException {
        if (this.matrix == null) {
            LuminanceSource source = this.getLuminanceSource();
            if (source.getWidth() >= 40 && source.getHeight() >= 40) {
                byte[] luminances = source.getMatrix();
                int width = source.getWidth();
                int height = source.getHeight();
                int subWidth = width >> 3;
                int subHeight = height >> 3;
                int[][] blackPoints = HybridBinarizer.calculateBlackPoints(luminances, subWidth, subHeight, width);
                this.matrix = new BitMatrix(width, height);
                HybridBinarizer.calculateThresholdForBlock(luminances, subWidth, subHeight, width, blackPoints, this.matrix);
            } else {
                this.matrix = super.getBlackMatrix();
            }
        }
    }

    private static void calculateThresholdForBlock(byte[] luminances, int subWidth, int subHeight, int stride, int[][] blackPoints, BitMatrix matrix) {
        for (int y = 0; y < subHeight; ++y) {
            for (int x = 0; x < subWidth; ++x) {
                int left = x > 1 ? x : 2;
                left = left < subWidth - 2 ? left : subWidth - 3;
                int top = y > 1 ? y : 2;
                top = top < subHeight - 2 ? top : subHeight - 3;
                int sum = 0;
                for (int z = -2; z <= 2; ++z) {
                    int[] blackRow = blackPoints[top + z];
                    sum += blackRow[left - 2];
                    sum += blackRow[left - 1];
                    sum += blackRow[left];
                    sum += blackRow[left + 1];
                    sum += blackRow[left + 2];
                }
                int average = sum / 25;
                HybridBinarizer.threshold8x8Block(luminances, x << 3, y << 3, average, stride, matrix);
            }
        }
    }

    private static void threshold8x8Block(byte[] luminances, int xoffset, int yoffset, int threshold, int stride, BitMatrix matrix) {
        for (int y = 0; y < 8; ++y) {
            int offset = (yoffset + y) * stride + xoffset;
            for (int x = 0; x < 8; ++x) {
                int pixel = luminances[offset + x] & 0xFF;
                if (pixel >= threshold) continue;
                matrix.set(xoffset + x, yoffset + y);
            }
        }
    }

    private static int[][] calculateBlackPoints(byte[] luminances, int subWidth, int subHeight, int stride) {
        int[][] blackPoints = new int[subHeight][subWidth];
        for (int y = 0; y < subHeight; ++y) {
            for (int x = 0; x < subWidth; ++x) {
                int average;
                int sum = 0;
                int min = 255;
                int max = 0;
                for (int yy = 0; yy < 8; ++yy) {
                    int offset = ((y << 3) + yy) * stride + (x << 3);
                    for (int xx = 0; xx < 8; ++xx) {
                        int pixel = luminances[offset + xx] & 0xFF;
                        sum += pixel;
                        if (pixel < min) {
                            min = pixel;
                        }
                        if (pixel <= max) continue;
                        max = pixel;
                    }
                }
                blackPoints[y][x] = average = max - min > 24 ? sum >> 6 : min >> 1;
            }
        }
        return blackPoints;
    }
}

