/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result.optional;

import com.google.zxing.Result;
import com.google.zxing.client.result.optional.AbstractNDEFResultParser;
import com.google.zxing.client.result.optional.NDEFRecord;
import com.google.zxing.client.result.optional.NDEFSmartPosterParsedResult;
import com.google.zxing.client.result.optional.NDEFTextResultParser;
import com.google.zxing.client.result.optional.NDEFURIResultParser;

final class NDEFSmartPosterResultParser
extends AbstractNDEFResultParser {
    NDEFSmartPosterResultParser() {
    }

    public static NDEFSmartPosterParsedResult parse(Result result) {
        byte[] bytes = result.getRawBytes();
        if (bytes == null) {
            return null;
        }
        NDEFRecord headerRecord = NDEFRecord.readRecord(bytes, 0);
        if (headerRecord == null || !headerRecord.isMessageBegin() || !headerRecord.isMessageEnd()) {
            return null;
        }
        if (!headerRecord.getType().equals("Sp")) {
            return null;
        }
        int recordNumber = 0;
        NDEFRecord ndefRecord = null;
        byte[] payload = headerRecord.getPayload();
        int action = -1;
        String title = null;
        String uri = null;
        for (int offset = 0; offset < payload.length && (ndefRecord = NDEFRecord.readRecord(payload, offset)) != null; offset += ndefRecord.getTotalRecordLength()) {
            if (recordNumber == 0 && !ndefRecord.isMessageBegin()) {
                return null;
            }
            String type = ndefRecord.getType();
            if ("T".equals(type)) {
                String[] languageText = NDEFTextResultParser.decodeTextPayload(ndefRecord.getPayload());
                title = languageText[1];
            } else if ("U".equals(type)) {
                uri = NDEFURIResultParser.decodeURIPayload(ndefRecord.getPayload());
            } else if ("act".equals(type)) {
                action = ndefRecord.getPayload()[0];
            }
            ++recordNumber;
        }
        if (recordNumber == 0 || ndefRecord != null && !ndefRecord.isMessageEnd()) {
            return null;
        }
        return new NDEFSmartPosterParsedResult(action, uri, title);
    }
}

