package grewe.drawimage;





import android.app.Activity;
import android.os.Bundle;
import android.widget.Button;
import android.view.View;
import android.widget.ImageView;

public class DrawImageActivity extends Activity {
   
	//button in GUI defined in main.xml
	Button image_button;  
	
	//ImageView object in GUI defined in main.xml
	ImageView iview;
	
	//Array of images that will cycle through and display in ImageView
	// represented by their IDS
	Integer[] imageIds = { R.drawable.veggies, R.drawable.fruit, R.drawable.dairy, R.drawable.snacks, R.drawable.drinks};
	
	//image index to cycle through images defined in imageIds
	int image_index =0;
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        //create a handle to our button so we can do event handling on it
        image_button = (Button) findViewById(R.id.btnChangeImage);
     
        image_button.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                // change the image to next image in imageIds array
            	 iview.setImageResource(imageIds[image_index]);
            	
         
            	  image_index++;
            	  //if at end of image array return to the first image
            	  if (image_index >= imageIds.length)
            	  { image_index =0; }
            		
            	
            	
            } });
        
        
        //create handle to our Image View
        iview = (ImageView) findViewById(R.id.image_display);
		
            

    }
}