package com.apofa.cameralab2;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PixelFormat;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Debug;
import android.provider.MediaStore.Images;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.View.OnClickListener;
import android.view.ViewGroup.LayoutParams;
import android.widget.ImageView;
import android.widget.Toast;

public class photoshoot extends Activity implements SurfaceHolder.Callback
{
    private static final String TAG = "photoshoot";
    Camera mCamera;
    boolean mPreviewRunning = false;
    byte[] tempdata;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    public void onCreate(Bundle icicle)
    {
        super.onCreate(icicle);
        Debug.startMethodTracing("mytrace");
        Log.e(TAG, "onCreate");
        getWindow().setFormat(PixelFormat.TRANSLUCENT);
        requestWindowFeature(Window.FEATURE_NO_TITLE); 
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN); 
        setContentView(R.layout.camera);
        
        ImageView iv = new ImageView(this);
        iv.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.icon));
        this.addContentView(iv, new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT));
        
        mSurfaceView = (SurfaceView)findViewById(R.id.surface);
        mSurfaceHolder = mSurfaceView.getHolder();
        
        mSurfaceHolder.addCallback(this);        
        mSurfaceHolder.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);
        this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        

        iv.setOnClickListener(new OnClickListener(){
    		public void onClick(View view){			
    		    {
    		    	
    		   		mCamera.takePicture(mShutterCallback, mPictureCallback,mjpeg);
    		    }
    		}
    		
    	});
 
    }


    Camera.ShutterCallback mShutterCallback = new Camera.ShutterCallback(){

		@Override
		public void onShutter() {
			// TODO Auto-generated method stub
			
		}
    	
    };
    Camera.PictureCallback mPictureCallback = new Camera.PictureCallback() {
        public void onPictureTaken(byte[] data, Camera c) {
        	if(data !=null)
        	{

        	}
        }
    };

    Camera.PictureCallback mjpeg = new Camera.PictureCallback() {
        public void onPictureTaken(byte[] data, Camera c) {
        	if(data !=null)
        	{
        		tempdata=data;
        		//showDialog(LOADLOCALIMAGE);
        		done();
            Log.e(TAG, "PICTURE JPEG CALLBACK: data.length = " + data.length);

        	}
        }
    };

    void done()
    {
     	 Bitmap bm = BitmapFactory.decodeByteArray(tempdata,0,tempdata.length);
         String url = Images.Media.insertImage(getContentResolver(),
         	 bm, null, null);	                                 
         bm.recycle();
         Bundle bundle = new Bundle();
         if(url!=null)
         {
        	 bundle.putString("url", url);
        	 
        	 Intent mIntent = new Intent();
        	 mIntent.putExtras(bundle);
        	 setResult(RESULT_OK, mIntent);
         }
         else
         {
        	 Toast.makeText(this, "Picture can not be saved", Toast.LENGTH_SHORT).show(); 
         }
//         Debug.stopMethodTracing();
         finish();
    }


    public void surfaceCreated(SurfaceHolder holder)
    {
        Log.e(TAG, "surfaceCreated");
        mCamera = Camera.open();
        //mCamera.startPreview();

    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h)
    {
	        Log.e(TAG, "surfaceChanged");
		try
		{
	        // XXX stopPreview() will crash if preview is not running
	        if (mPreviewRunning) {
	            mCamera.stopPreview();
	        }
	
	        Camera.Parameters p = mCamera.getParameters();
	        p.setPreviewSize(w, h);
/*
	        p.set("rotation", 90);
	        
	        p.setPictureSize(480,640);
	*/        
	        mCamera.setParameters(p);
	        mCamera.setPreviewDisplay(holder);
	        mCamera.startPreview();
	        mPreviewRunning = true;
		}
		catch(Exception e)
		{
			Log.d("",e.toString());
		}
    }



    public void surfaceDestroyed(SurfaceHolder holder)
    {
        Log.e(TAG, "surfaceDestroyed");
        mCamera.stopPreview();
        mPreviewRunning = false;
        mCamera.release();
        mCamera=null;
    }


}

