package com.apofa.cameralab2;



import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;

public class cameralab2 extends Activity {
    /** Called when the activity is first created. */
	final int CAMERALAB1=1;
	final int CAMERALAB2=2;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //loades interface stored in main.xml of layout directory
        setContentView(R.layout.main);
        Button cameraButton = (Button) findViewById(R.id.camera);
        
        //setups button to have even so that it creates an Activity
        //of instance photoshoot.class and start it as an
        //Activity
        cameraButton.setOnClickListener( new OnClickListener(){
            public void onClick(View v ){
               	Intent i = new Intent(cameralab2.this, photoshoot.class);
                startActivityForResult(i,CAMERALAB2);
            }
        });

    }
    
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode== CAMERALAB1 && resultCode == Activity.RESULT_OK){
        	Log.v("Result","Result:"+data.toURI());

            Bundle extras = data.getExtras();

            Bitmap b = (Bitmap) extras.get("data"); 
                ((ImageView)findViewById(R.id.picture)).setImageBitmap(b);
        }
        else if (requestCode== CAMERALAB2 && resultCode == Activity.RESULT_OK){
        	Log.v("Result","Result:"+data.toURI());
        	Bundle extras = data.getExtras();
        	String imageurl = extras.getString("url");
        	Uri imgUri = Uri.parse(imageurl);
            ((ImageView)findViewById(R.id.picture)).setImageURI(imgUri);
        }
    }
}