package com.google.zxing.integration.android;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class Screen1 extends Activity implements View.OnClickListener {
	Button btnStartScan, btnSearchAmazon,btnSearchGoogle;
	TextView tvBarCodeType, tvBarCode;
	Boolean hasBarCode=false;
	String searchIn, barcode;
	String urlAmazon,urlGoogle;
	Class selectedClass;
	
	

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.screen1);
		initializeViews();		
	}

	private void initializeViews() {
		// TODO Auto-generated method stub
		
		// initializing the views of the layout.
		
		btnStartScan = (Button) findViewById(R.id.screen1_btnStartScan);		
		btnSearchAmazon = (Button) findViewById(R.id.screen1_btnAmazon);
		btnSearchGoogle = (Button) findViewById(R.id.screen1_btnGoogle);
		tvBarCodeType = (TextView) findViewById(R.id.screen1_tvBarcodeType);
		tvBarCode = (TextView) findViewById(R.id.screen1_tvBarcode);
		
		
		// setting an OnClickListener to the buttons
		btnStartScan.setOnClickListener(this);
		btnSearchAmazon.setOnClickListener(this);
		btnSearchGoogle.setOnClickListener(this);
		
	}

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		switch(v.getId())
		{
		case R.id.screen1_btnStartScan:  // to invoke a scan 
			IntentIntegrator integrator = new IntentIntegrator(Screen1.this);
			integrator.initiateScan();
			break;
			
		case R.id.screen1_btnAmazon:   // to search for the barcode obtained in Amazon
			if(hasBarCode)  // Only search if the barcode is scanned and resolved
			{
			searchIn = "Amazon"; // used in the Internet.java class to decide whether to load Amazon or Google url
			urlAmazon="http://www.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&field-keywords="+barcode;	// creating the amazon url
			urlGoogle="http://www.google.com/search?q="+barcode+"&tbm=shop"; // creating the Google url
			
			/*
			 Creating a bundle and placing the url's of Amazon and Google search in String.
			 */
			
			Bundle basket = new Bundle();
			basket.putString("urlAmazon", urlAmazon);
			basket.putString("urlGoogle", urlGoogle);			
			basket.putString("searchIn", searchIn);
			Intent i = new Intent(Screen1.this, Internet.class);
			i.putExtras(basket);
			startActivity(i);	
			}
			else   // prompt the user to scan a barcode before searching 
			{
				try {
					selectedClass = Class.forName("com.google.zxing.integration.android.Message");
				} catch (ClassNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				Intent ourIntent = new Intent(Screen1.this,selectedClass); // (context,class variable)
				startActivity(ourIntent);
			}
			break;
			
		case R.id.screen1_btnGoogle:  // to search for the barcode obtained in Amazon
			if(hasBarCode)  // Only search if the barcode is scanned and resolved
			{
				
			searchIn = "Google";  // used in the Internet.java class to decide whether to load Amazon or Google url
			urlAmazon="http://www.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&field-keywords="+barcode;	 // creating the amazon url
			urlGoogle="http://www.google.com/search?q="+barcode+"&tbm=shop";					 // creating the google url
			
			/*
			 Creating a bundle and placing the url's of Amazon and Google search in String.
			 */
			Bundle basket2 = new Bundle();
			basket2.putString("urlAmazon", urlAmazon);
			basket2.putString("urlGoogle", urlGoogle);			
			basket2.putString("searchIn", searchIn);
			Intent i2 = new Intent(Screen1.this, Internet.class);
			i2.putExtras(basket2);
			startActivity(i2);	
			}
			else  // prompt the user to scan a barcode before searching 
			{
				try {
					selectedClass = Class.forName("com.google.zxing.integration.android.Message");
				} catch (ClassNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				Intent ourIntent = new Intent(Screen1.this,selectedClass); // (context,class variable)
				startActivity(ourIntent);
			}		
			break;		
		
		};
		
	}
	 
	
	
	
	
	public void onActivityResult(int requestCode, int resultCode, Intent intent) {
		  IntentResult scanResult = IntentIntegrator.parseActivityResult(requestCode, resultCode, intent);
		  if (scanResult != null) {
			// Retrieving the result of the scan
			  
			  Bundle received_bundle = intent.getExtras();			  
			  String type = received_bundle.getString("SCAN_RESULT_FORMAT");			  
			  barcode = received_bundle.getString("SCAN_RESULT");
			  tvBarCodeType.setText("Code Type: "+type);
			  tvBarCode.setText("Code: "+barcode);	
			  hasBarCode = true;
			  
		  }
		  else{
			  tvBarCodeType.setText("");			  
			  tvBarCode.setText("Sorry unable to scan");			  
		  }
			  
		  
		}
	

}
