package com.google.zxing.integration.android;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.TextView;

public class Internet extends Activity implements OnClickListener {	
	TextView tv_url;
	String urlAmazon,urlGoogle,searchIn;
	WebView ourBrowser;
	Button btnAmazon, btnGoogle;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.internet);
		initializeViews();
	}


	private void initializeViews() {
		// TODO Auto-generated method stub
		
		btnAmazon = (Button) findViewById(R.id.internet_btnSwitchToAmazon);
		btnGoogle = (Button) findViewById(R.id.internet_btnSwitchToGoogle);
		
		btnAmazon.setOnClickListener(this);
		btnGoogle.setOnClickListener(this);
		
		tv_url = (TextView) findViewById(R.id.internet_tvUrl); 			
		Bundle gotBasket = getIntent().getExtras();
		urlAmazon = gotBasket.getString("urlAmazon");	
		urlGoogle = gotBasket.getString("urlGoogle");	
		searchIn = gotBasket.getString("searchIn");
		
		
		// customizing our WebView to enable JavaScript, set OverView as the default View
		ourBrowser = (WebView) findViewById(R.id.internet_browser);
		ourBrowser.getSettings().setJavaScriptEnabled(true);
		ourBrowser.getSettings().setLoadWithOverviewMode(true);
		ourBrowser.getSettings().setUseWideViewPort(true);		
		ourBrowser.setWebViewClient(new ourViewClient()); 
		
		
		if(searchIn.contentEquals("Amazon"))  // if the Amazon button has been clicked load the WebView with amazon url
		{
			btnAmazon.setVisibility(View.GONE);
			btnGoogle.setVisibility(View.VISIBLE);
			tv_url.setText("search results from Amazon");
			ourBrowser.loadUrl(urlAmazon);			
			
		}
		else if(searchIn.contentEquals("Google"))  // if the Google button has been clicked load the WebView with amazon url
		{
			btnAmazon.setVisibility(View.VISIBLE);
			btnGoogle.setVisibility(View.GONE);
			tv_url.setText("search results from Google");
			ourBrowser.loadUrl(urlGoogle);			
		}
	}


	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		switch(v.getId())
		{
			case R.id.internet_btnSwitchToAmazon:
				btnAmazon.setVisibility(View.GONE);
				btnGoogle.setVisibility(View.VISIBLE);
				tv_url.setText("search results from Amazon");
				ourBrowser.loadUrl(urlAmazon);				
				break;
				
			case R.id.internet_btnSwitchToGoogle:
				btnAmazon.setVisibility(View.VISIBLE);
				btnGoogle.setVisibility(View.GONE);
				tv_url.setText("search results from Google");
				ourBrowser.loadUrl(urlGoogle);
				break;
		};
		
	}	

}
