/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.TintResources;
import android.support.v7.widget.VectorEnabledTintResources;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class TintContextWrapper
extends ContextWrapper {
    private static final ArrayList<WeakReference<TintContextWrapper>> sCache = new ArrayList();
    private final Resources mResources;
    private final Resources.Theme mTheme;

    public static Context wrap(@NonNull Context context) {
        if (TintContextWrapper.shouldWrap(context)) {
            int count = sCache.size();
            for (int i = 0; i < count; ++i) {
                TintContextWrapper wrapper;
                WeakReference<TintContextWrapper> ref = sCache.get(i);
                TintContextWrapper tintContextWrapper = wrapper = ref != null ? (TintContextWrapper)((Object)ref.get()) : null;
                if (wrapper == null || wrapper.getBaseContext() != context) continue;
                return wrapper;
            }
            TintContextWrapper wrapper = new TintContextWrapper(context);
            sCache.add(new WeakReference<TintContextWrapper>(wrapper));
            return wrapper;
        }
        return context;
    }

    private static boolean shouldWrap(@NonNull Context context) {
        if (context instanceof TintContextWrapper || context.getResources() instanceof TintResources || context.getResources() instanceof VectorEnabledTintResources) {
            return false;
        }
        return !AppCompatDelegate.isCompatVectorFromResourcesEnabled() || Build.VERSION.SDK_INT <= 20;
    }

    private TintContextWrapper(@NonNull Context base) {
        super(base);
        if (VectorEnabledTintResources.shouldBeUsed()) {
            this.mResources = new VectorEnabledTintResources((Context)this, base.getResources());
            this.mTheme = this.mResources.newTheme();
            this.mTheme.setTo(base.getTheme());
        } else {
            this.mResources = new TintResources((Context)this, base.getResources());
            this.mTheme = null;
        }
    }

    public Resources.Theme getTheme() {
        return this.mTheme == null ? super.getTheme() : this.mTheme;
    }

    public void setTheme(int resid) {
        if (this.mTheme == null) {
            super.setTheme(resid);
        } else {
            this.mTheme.applyStyle(resid, true);
        }
    }

    public Resources getResources() {
        return this.mResources;
    }
}

