/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.os.Build;
import android.support.v4.view.accessibility.AccessibilityManagerCompatIcs;
import android.support.v4.view.accessibility.AccessibilityManagerCompatKitKat;
import android.view.accessibility.AccessibilityManager;
import java.util.Collections;
import java.util.List;

public final class AccessibilityManagerCompat {
    private static final AccessibilityManagerVersionImpl IMPL = Build.VERSION.SDK_INT >= 19 ? new AccessibilityManagerKitKatImpl() : (Build.VERSION.SDK_INT >= 14 ? new AccessibilityManagerIcsImpl() : new AccessibilityManagerStubImpl());

    public static boolean addAccessibilityStateChangeListener(AccessibilityManager manager, AccessibilityStateChangeListener listener) {
        return IMPL.addAccessibilityStateChangeListener(manager, listener);
    }

    public static boolean removeAccessibilityStateChangeListener(AccessibilityManager manager, AccessibilityStateChangeListener listener) {
        return IMPL.removeAccessibilityStateChangeListener(manager, listener);
    }

    public static List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(AccessibilityManager manager) {
        return IMPL.getInstalledAccessibilityServiceList(manager);
    }

    public static List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(AccessibilityManager manager, int feedbackTypeFlags) {
        return IMPL.getEnabledAccessibilityServiceList(manager, feedbackTypeFlags);
    }

    public static boolean isTouchExplorationEnabled(AccessibilityManager manager) {
        return IMPL.isTouchExplorationEnabled(manager);
    }

    public static boolean addTouchExplorationStateChangeListener(AccessibilityManager manager, TouchExplorationStateChangeListener listener) {
        return IMPL.addTouchExplorationStateChangeListener(manager, listener);
    }

    public static boolean removeTouchExplorationStateChangeListener(AccessibilityManager manager, TouchExplorationStateChangeListener listener) {
        return IMPL.removeTouchExplorationStateChangeListener(manager, listener);
    }

    private AccessibilityManagerCompat() {
    }

    public static interface TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean var1);
    }

    public static interface AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean var1);
    }

    @Deprecated
    public static abstract class AccessibilityStateChangeListenerCompat
    implements AccessibilityStateChangeListener {
    }

    static class AccessibilityManagerKitKatImpl
    extends AccessibilityManagerIcsImpl {
        AccessibilityManagerKitKatImpl() {
        }

        @Override
        public AccessibilityManagerCompatKitKat.TouchExplorationStateChangeListenerWrapper newTouchExplorationStateChangeListener(final TouchExplorationStateChangeListener listener) {
            return new AccessibilityManagerCompatKitKat.TouchExplorationStateChangeListenerWrapper((Object)listener, new AccessibilityManagerCompatKitKat.TouchExplorationStateChangeListenerBridge(){

                public void onTouchExplorationStateChanged(boolean enabled) {
                    listener.onTouchExplorationStateChanged(enabled);
                }
            });
        }

        @Override
        public boolean addTouchExplorationStateChangeListener(AccessibilityManager manager, TouchExplorationStateChangeListener listener) {
            return AccessibilityManagerCompatKitKat.addTouchExplorationStateChangeListener((AccessibilityManager)manager, (Object)this.newTouchExplorationStateChangeListener(listener));
        }

        @Override
        public boolean removeTouchExplorationStateChangeListener(AccessibilityManager manager, TouchExplorationStateChangeListener listener) {
            return AccessibilityManagerCompatKitKat.removeTouchExplorationStateChangeListener((AccessibilityManager)manager, (Object)this.newTouchExplorationStateChangeListener(listener));
        }
    }

    static class AccessibilityManagerIcsImpl
    extends AccessibilityManagerStubImpl {
        AccessibilityManagerIcsImpl() {
        }

        @Override
        public AccessibilityManagerCompatIcs.AccessibilityStateChangeListenerWrapper newAccessibilityStateChangeListener(final AccessibilityStateChangeListener listener) {
            return new AccessibilityManagerCompatIcs.AccessibilityStateChangeListenerWrapper((Object)listener, new AccessibilityManagerCompatIcs.AccessibilityStateChangeListenerBridge(){

                public void onAccessibilityStateChanged(boolean enabled) {
                    listener.onAccessibilityStateChanged(enabled);
                }
            });
        }

        @Override
        public boolean addAccessibilityStateChangeListener(AccessibilityManager manager, AccessibilityStateChangeListener listener) {
            return AccessibilityManagerCompatIcs.addAccessibilityStateChangeListener((AccessibilityManager)manager, (AccessibilityManagerCompatIcs.AccessibilityStateChangeListenerWrapper)this.newAccessibilityStateChangeListener(listener));
        }

        @Override
        public boolean removeAccessibilityStateChangeListener(AccessibilityManager manager, AccessibilityStateChangeListener listener) {
            return AccessibilityManagerCompatIcs.removeAccessibilityStateChangeListener((AccessibilityManager)manager, (AccessibilityManagerCompatIcs.AccessibilityStateChangeListenerWrapper)this.newAccessibilityStateChangeListener(listener));
        }

        @Override
        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(AccessibilityManager manager, int feedbackTypeFlags) {
            return AccessibilityManagerCompatIcs.getEnabledAccessibilityServiceList((AccessibilityManager)manager, (int)feedbackTypeFlags);
        }

        @Override
        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(AccessibilityManager manager) {
            return AccessibilityManagerCompatIcs.getInstalledAccessibilityServiceList((AccessibilityManager)manager);
        }

        @Override
        public boolean isTouchExplorationEnabled(AccessibilityManager manager) {
            return AccessibilityManagerCompatIcs.isTouchExplorationEnabled((AccessibilityManager)manager);
        }
    }

    static class AccessibilityManagerStubImpl
    implements AccessibilityManagerVersionImpl {
        AccessibilityManagerStubImpl() {
        }

        @Override
        public AccessibilityManagerCompatIcs.AccessibilityStateChangeListenerWrapper newAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
            return null;
        }

        @Override
        public boolean addAccessibilityStateChangeListener(AccessibilityManager manager, AccessibilityStateChangeListener listener) {
            return false;
        }

        @Override
        public boolean removeAccessibilityStateChangeListener(AccessibilityManager manager, AccessibilityStateChangeListener listener) {
            return false;
        }

        @Override
        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(AccessibilityManager manager, int feedbackTypeFlags) {
            return Collections.emptyList();
        }

        @Override
        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(AccessibilityManager manager) {
            return Collections.emptyList();
        }

        @Override
        public boolean isTouchExplorationEnabled(AccessibilityManager manager) {
            return false;
        }

        @Override
        public AccessibilityManagerCompatKitKat.TouchExplorationStateChangeListenerWrapper newTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
            return null;
        }

        @Override
        public boolean addTouchExplorationStateChangeListener(AccessibilityManager manager, TouchExplorationStateChangeListener listener) {
            return false;
        }

        @Override
        public boolean removeTouchExplorationStateChangeListener(AccessibilityManager manager, TouchExplorationStateChangeListener listener) {
            return false;
        }
    }

    static interface AccessibilityManagerVersionImpl {
        public AccessibilityManagerCompatIcs.AccessibilityStateChangeListenerWrapper newAccessibilityStateChangeListener(AccessibilityStateChangeListener var1);

        public boolean addAccessibilityStateChangeListener(AccessibilityManager var1, AccessibilityStateChangeListener var2);

        public boolean removeAccessibilityStateChangeListener(AccessibilityManager var1, AccessibilityStateChangeListener var2);

        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(AccessibilityManager var1, int var2);

        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(AccessibilityManager var1);

        public boolean isTouchExplorationEnabled(AccessibilityManager var1);

        public AccessibilityManagerCompatKitKat.TouchExplorationStateChangeListenerWrapper newTouchExplorationStateChangeListener(TouchExplorationStateChangeListener var1);

        public boolean addTouchExplorationStateChangeListener(AccessibilityManager var1, TouchExplorationStateChangeListener var2);

        public boolean removeTouchExplorationStateChangeListener(AccessibilityManager var1, TouchExplorationStateChangeListener var2);
    }
}

