/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Service;
import android.support.v4.app.ServiceCompatApi24;
import android.support.v4.os.BuildCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ServiceCompat {
    public static final int START_STICKY = 1;
    public static final int STOP_FOREGROUND_REMOVE = 1;
    public static final int STOP_FOREGROUND_DETACH = 2;
    static final ServiceCompatImpl IMPL = BuildCompat.isAtLeastN() ? new Api24ServiceCompatImpl() : new BaseServiceCompatImpl();

    private ServiceCompat() {
    }

    public static void stopForeground(Service service, int flags) {
        IMPL.stopForeground(service, flags);
    }

    static class Api24ServiceCompatImpl
    implements ServiceCompatImpl {
        Api24ServiceCompatImpl() {
        }

        @Override
        public void stopForeground(Service service, int flags) {
            ServiceCompatApi24.stopForeground((Service)service, (int)flags);
        }
    }

    static class BaseServiceCompatImpl
    implements ServiceCompatImpl {
        BaseServiceCompatImpl() {
        }

        @Override
        public void stopForeground(Service service, int flags) {
            service.stopForeground((flags & 1) != 0);
        }
    }

    static interface ServiceCompatImpl {
        public void stopForeground(Service var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StopForegroundFlags {
    }
}

