package com.authorwjf.list_fragments;

import android.app.ListFragment;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.util.Log;

public class ListFrag extends ListFragment{
	//Ids of res/drawable-hdpi* images stored there
	Integer[] imageIds = { R.drawable.veggies, R.drawable.fruit, R.drawable.dairy, R.drawable.snacks, R.drawable.drinks};
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}

	@Override
	public void onActivityCreated(Bundle savedInstanceState) {
		super.onActivityCreated(savedInstanceState);
		String[] values = new String[] { "veggies", "fruit", "dairy", "snacks", "drinks"};
		ArrayAdapter<String> adapter = new ArrayAdapter<String>(getActivity(), android.R.layout.simple_list_item_1, values);
		setListAdapter(adapter);
	}

	@Override
	public void onListItemClick(ListView l, View v, int position, long id) {
		String item = (String) getListAdapter().getItem(position);
		System.out.println("item is" + item);
		Log.v("onListItemClick detail fragment", "item is " +item);
		//get the fragment that contains the caption --DetailFrag
		DetailFrag frag = (DetailFrag) getFragmentManager().findFragmentById(R.id.frag_capt);
		if (frag != null && frag.isInLayout()) {
			frag.setText(getCapt(item));
			frag.setImage(this.imageIds[position]);
		}
	}
	
	//compare the string chosen by user to the ones (in lower case) set
	//in the ListAdapter
	private String getCapt(String ship) {
		if (ship.toLowerCase().contains("veggies")) {
			return "Artichokes at $1.99 each";
		}
		if (ship.toLowerCase().contains("fruit")) {
			return "Gala Apples at 99 cents a pound";
		}
		if (ship.toLowerCase().contains("dairy")) {
			return "Fresh Locally Made Yogurt $4.00 quart";
		}
		if (ship.toLowerCase().contains("snacks")) {
			return "Doritos $2.99 large family size";
		}
		if (ship.toLowerCase().contains("drinks")) {
			return "Diet Pepsi - $2.00 12 pack";
		}
		return "???";
	}
}
